/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.connect;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.connect.ExposeOptions;
import io.vertx.ext.consul.connect.UpstreamOptions;
import java.util.List;
import java.util.stream.Collectors;

@DataObject
public class ProxyOptions {
    private static final String CONFIG = "Config";
    private static final String UPSTREAMS = "Upstreams";
    private static final String EXPOSE = "Expose";
    private JsonObject config;
    private List<UpstreamOptions> upstreams;
    private ExposeOptions expose;

    public ProxyOptions() {
    }

    public ProxyOptions(JsonObject options) {
        this.config = options.getJsonObject(CONFIG);
        this.upstreams = options.getJsonArray(UPSTREAMS).stream().map(o -> new UpstreamOptions((JsonObject)o)).collect(Collectors.toList());
        this.expose = new ExposeOptions(options.getJsonObject(EXPOSE));
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.upstreams != null) {
            jsonObject.put(UPSTREAMS, this.upstreams.stream().map(UpstreamOptions::toJson).collect(Collectors.toList()));
        }
        if (this.config != null) {
            jsonObject.put(CONFIG, (Object)this.config);
        }
        if (this.expose != null) {
            jsonObject.put(EXPOSE, (Object)this.expose.toJson());
        }
        return jsonObject;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public ProxyOptions setConfig(JsonObject config) {
        this.config = config;
        return this;
    }

    public List<UpstreamOptions> getUpstreams() {
        return this.upstreams;
    }

    public ProxyOptions setUpstreams(List<UpstreamOptions> upstreams) {
        this.upstreams = upstreams;
        return this;
    }

    public ExposeOptions getExpose() {
        return this.expose;
    }

    public ProxyOptions setExpose(ExposeOptions expose) {
        this.expose = expose;
        return this;
    }
}

