/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Coordinate;
import io.vertx.ext.consul.DcCoordinates;
import java.util.stream.Collectors;

class CoordinateParser {
    private static final String NODE_KEY = "Node";
    private static final String COORD_KEY = "Coord";
    private static final String ADJ_KEY = "Adjustment";
    private static final String ERR_KEY = "Error";
    private static final String HEIGHT_KEY = "Height";
    private static final String VEC_KEY = "Vec";
    private static final String DATACENTER_KEY = "Datacenter";
    private static final String COORDS_KEY = "Coordinates";

    CoordinateParser() {
    }

    static Coordinate parse(JsonObject json) {
        Coordinate coordinate = new Coordinate().setNode(json.getString(NODE_KEY));
        JsonObject coord = json.getJsonObject(COORD_KEY);
        if (coord != null) {
            coordinate.setAdj(coord.getFloat(ADJ_KEY, Float.valueOf(0.0f)).floatValue()).setErr(coord.getFloat(ERR_KEY, Float.valueOf(0.0f)).floatValue()).setHeight(coord.getFloat(HEIGHT_KEY, Float.valueOf(0.0f)).floatValue());
            JsonArray arr = coord.getJsonArray(VEC_KEY);
            coordinate.setVec(arr == null ? null : arr.stream().map(o -> Float.valueOf(o instanceof Number ? ((Number)o).floatValue() : 0.0f)).collect(Collectors.toList()));
        }
        return coordinate;
    }

    static DcCoordinates parseDc(JsonObject json) {
        return new DcCoordinates().setDatacenter(json.getString(DATACENTER_KEY)).setServers(json.getJsonArray(COORDS_KEY).stream().map(obj -> CoordinateParser.parse((JsonObject)obj)).collect(Collectors.toList()));
    }
}

