/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.shareddata;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.shareddata.impl.SharedMap;
import org.vertx.java.core.shareddata.impl.SharedSet;

public class SharedData {
    private static final Logger log = LoggerFactory.getLogger(SharedData.class);
    private ConcurrentMap<Object, SharedMap<?, ?>> maps = new ConcurrentHashMap();
    private ConcurrentMap<Object, SharedSet<?>> sets = new ConcurrentHashMap();

    public <K, V> ConcurrentMap<K, V> getMap(String name) {
        SharedMap prev;
        SharedMap map = (SharedMap)this.maps.get(name);
        if (map == null && (prev = this.maps.putIfAbsent(name, map = new SharedMap())) != null) {
            map = prev;
        }
        return map;
    }

    public <E> Set<E> getSet(String name) {
        SharedSet prev;
        SharedSet set = (SharedSet)this.sets.get(name);
        if (set == null && (prev = this.sets.putIfAbsent(name, set = new SharedSet())) != null) {
            set = prev;
        }
        return set;
    }

    public boolean removeMap(Object name) {
        return this.maps.remove(name) != null;
    }

    public boolean removeSet(Object name) {
        return this.sets.remove(name) != null;
    }
}

