/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientConnectionInternal;
import io.vertx.core.http.impl.WebSocketImpl;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.resource.ManagedResource;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.ArrayDeque;
import java.util.Deque;

class WebSocketGroup
extends ManagedResource {
    private final WebSocketClientOptions options;
    private final int maxPoolSize;
    private final HttpChannelConnector connector;
    private final Deque<Waiter> waiters;
    private int inflightConnections;
    private final ClientMetrics clientMetrics;
    private final PoolMetrics poolMetrics;

    WebSocketGroup(ClientMetrics clientMetrics, PoolMetrics poolMetrics, WebSocketClientOptions options, int maxPoolSize, HttpChannelConnector connector) {
        this.options = options;
        this.maxPoolSize = maxPoolSize;
        this.connector = connector;
        this.waiters = new ArrayDeque<Waiter>();
        this.clientMetrics = clientMetrics;
        this.poolMetrics = poolMetrics;
    }

    public Future<WebSocket> requestConnection(ContextInternal ctx, WebSocketConnectOptions connectOptions, long timeout) {
        Future<WebSocket> fut = this.requestConnection2(ctx, connectOptions, timeout);
        if (this.poolMetrics != null) {
            Object metric = this.poolMetrics.enqueue();
            fut = fut.andThen(ar -> this.poolMetrics.dequeue(metric));
        }
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEvict() {
        Waiter h;
        this.decRefCount();
        WebSocketGroup webSocketGroup = this;
        synchronized (webSocketGroup) {
            if (--this.inflightConnections > this.maxPoolSize || this.waiters.isEmpty()) {
                return;
            }
            h = this.waiters.poll();
        }
        this.tryConnect(h.context, h.connectOptions).onComplete(h.promise);
    }

    private Future<WebSocket> tryConnect(ContextInternal ctx, WebSocketConnectOptions connectOptions) {
        ContextInternal eventLoopContext = ctx.isEventLoopContext() ? ctx : ctx.owner().createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
        Future<HttpClientConnectionInternal> fut = this.connector.httpConnect(eventLoopContext);
        return fut.compose(c -> {
            if (!this.incRefCount()) {
                c.close();
                return Future.failedFuture(new VertxException("Connection closed", true));
            }
            long timeout = Math.max(connectOptions.getTimeout(), 0L);
            if (connectOptions.getIdleTimeout() >= 0L) {
                timeout = connectOptions.getIdleTimeout();
            }
            Http1xClientConnection ci = (Http1xClientConnection)c;
            PromiseInternal<WebSocket> promise = ctx.promise();
            ci.toWebSocket(ctx, connectOptions.getURI(), connectOptions.getHeaders(), connectOptions.getAllowOriginHeader(), this.options, connectOptions.getVersion(), connectOptions.getSubProtocols(), timeout, connectOptions.isRegisterWriteHandlers(), this.options.getMaxFrameSize(), promise);
            return promise.future().andThen(ar -> {
                if (ar.succeeded()) {
                    WebSocketImpl wsi = (WebSocketImpl)ar.result();
                    wsi.evictionHandler(v -> this.onEvict());
                } else {
                    this.onEvict();
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Future<WebSocket> requestConnection2(ContextInternal ctx, WebSocketConnectOptions connectOptions, long timeout) {
        WebSocketGroup webSocketGroup = this;
        synchronized (webSocketGroup) {
            if (this.inflightConnections >= this.maxPoolSize) {
                Waiter waiter = new Waiter(ctx, connectOptions);
                this.waiters.add(waiter);
                return waiter.promise.future();
            }
            ++this.inflightConnections;
        }
        return this.tryConnect(ctx, connectOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleShutdown() {
        WebSocketGroup webSocketGroup = this;
        synchronized (webSocketGroup) {
            for (Waiter waiter : this.waiters) {
                waiter.promise.fail("Closed");
            }
            this.waiters.clear();
        }
    }

    @Override
    protected void cleanup() {
        if (this.clientMetrics != null) {
            this.clientMetrics.close();
        }
        if (this.poolMetrics != null) {
            this.poolMetrics.close();
        }
    }

    private static class Waiter {
        final Promise<WebSocket> promise;
        final ContextInternal context;
        final WebSocketConnectOptions connectOptions;

        Waiter(ContextInternal context, WebSocketConnectOptions connectOptions) {
            this.promise = context.promise();
            this.context = context;
            this.connectOptions = connectOptions;
        }
    }
}

