/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.deployment;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.deployment.Deployment;
import io.vertx.core.impl.deployment.DeploymentContext;
import io.vertx.core.impl.deployment.DeploymentManager;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultDeploymentManager
implements DeploymentManager {
    public static final Logger log = LoggerFactory.getLogger(DefaultDeploymentManager.class);
    private final VertxImpl vertx;
    private final Map<String, DeploymentContext> deploying = new HashMap<String, DeploymentContext>();
    private final Map<String, DeploymentContext> deployments = new ConcurrentHashMap<String, DeploymentContext>();

    public DefaultDeploymentManager(VertxImpl vertx) {
        this.vertx = vertx;
    }

    private String generateDeploymentID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public Future<Void> undeploy(String deploymentID) {
        DeploymentContext deployment = this.deployments.get(deploymentID);
        ContextInternal currentContext = this.vertx.getOrCreateContext();
        if (deployment == null) {
            return currentContext.failedFuture(new IllegalStateException("Unknown deployment"));
        }
        return deployment.undeploy(this.vertx.getOrCreateContext());
    }

    @Override
    public Collection<DeploymentContext> deployments() {
        return new HashSet<DeploymentContext>(this.deployments.values());
    }

    @Override
    public DeploymentContext getDeployment(String deploymentID) {
        return this.deployments.get(deploymentID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> undeployAll() {
        ArrayList<Object> completionList = new ArrayList<Object>();
        while (true) {
            DeploymentContextImpl deployment;
            Map<String, DeploymentContext> map = this.deploying;
            synchronized (map) {
                if (this.deploying.isEmpty()) {
                    break;
                }
                Iterator<Map.Entry<String, DeploymentContext>> it = this.deploying.entrySet().iterator();
                Map.Entry<String, DeploymentContext> entry = it.next();
                it.remove();
                deployment = (DeploymentContextImpl)entry.getValue();
            }
            Future<?> f = deployment.deployment.undeploy();
            completionList.add(f);
        }
        HashSet<String> deploymentIDs = new HashSet<String>();
        for (Map.Entry<String, DeploymentContext> entry : this.deployments.entrySet()) {
            if (entry.getValue().isChild()) continue;
            deploymentIDs.add(entry.getKey());
        }
        for (String deploymentID : deploymentIDs) {
            Promise promise = Promise.promise();
            completionList.add(promise.future());
            this.undeploy(deploymentID).onComplete(ar -> {
                if (ar.failed()) {
                    log.error((Object)"Undeploy failed", ar.cause());
                }
                promise.handle(ar);
            });
        }
        PromiseInternal promise = this.vertx.getOrCreateContext().promise();
        Future.join(completionList).mapEmpty().onComplete(promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<DeploymentContext> deploy(DeploymentContext parent, ContextInternal callingContext, Deployment deployment) {
        String deploymentID = this.generateDeploymentID();
        DeploymentContextImpl context = new DeploymentContextImpl(deployment, parent, deploymentID);
        Map<String, DeploymentContext> map = this.deploying;
        synchronized (map) {
            this.deploying.put(deploymentID, context);
        }
        PromiseInternal result = callingContext.promise();
        Future<?> f = deployment.deploy(context);
        f.onComplete(ar -> {
            if (ar.succeeded()) {
                boolean removedFromDeploying;
                this.deployments.put(deploymentID, context);
                if (parent != null) {
                    if (parent.addChild(context)) {
                        context.child = true;
                    } else {
                        context.undeploy(this.vertx.getOrCreateContext()).onComplete(ar2 -> result.fail("Deployment failed.Could not be added as child of parent deployment"));
                        return;
                    }
                }
                Map<String, DeploymentContext> map = this.deploying;
                synchronized (map) {
                    removedFromDeploying = this.deploying.remove(deploymentID) != null;
                }
                assert (removedFromDeploying);
                result.complete(context);
            } else {
                context.rollback(callingContext).onComplete(ar2 -> result.fail(ar.cause()));
            }
        });
        return result.future();
    }

    private class DeploymentContextImpl
    implements DeploymentContext {
        private static final int ST_DEPLOYED = 0;
        private static final int ST_UNDEPLOYING = 1;
        private static final int ST_UNDEPLOYED = 2;
        private final Deployment deployment;
        private final DeploymentContext parent;
        private final String deploymentID;
        private final Set<DeploymentContext> children = ConcurrentHashMap.newKeySet();
        private int status = 0;
        private volatile boolean child;

        private DeploymentContextImpl(Deployment deployment, DeploymentContext parent, String deploymentID) {
            this.deployment = deployment;
            this.parent = parent;
            this.deploymentID = deploymentID;
        }

        private synchronized Future<?> rollback(ContextInternal callingContext) {
            if (this.status == 0) {
                this.status = 1;
                return this.doUndeployChildren(callingContext).transform(childrenResult -> {
                    DeploymentContextImpl deploymentContextImpl = this;
                    synchronized (deploymentContextImpl) {
                        this.status = 2;
                    }
                    if (childrenResult.failed()) {
                        return (Future)childrenResult;
                    }
                    return this.deployment.cleanup();
                });
            }
            return callingContext.succeededFuture();
        }

        private synchronized Future<?> doUndeployChildren(ContextInternal undeployingContext) {
            if (!this.children.isEmpty()) {
                ArrayList<Future<Void>> childFuts = new ArrayList<Future<Void>>();
                for (DeploymentContext childDeployment : new HashSet<DeploymentContext>(this.children)) {
                    childFuts.add(childDeployment.undeploy(undeployingContext).andThen(ar -> this.children.remove(childDeployment)));
                }
                return Future.all(childFuts);
            }
            return Future.succeededFuture();
        }

        @Override
        public synchronized Future<Void> undeploy(ContextInternal undeployingContext) {
            if (this.status == 2) {
                return undeployingContext.failedFuture(new IllegalStateException("Already undeployed"));
            }
            if (!this.children.isEmpty()) {
                this.status = 1;
                return this.doUndeployChildren(undeployingContext).compose(v -> this.undeploy(undeployingContext));
            }
            this.status = 2;
            if (this.parent != null) {
                this.parent.removeChild(this);
            }
            Future<?> undeployFutures = this.deployment.undeploy().andThen(ar -> DefaultDeploymentManager.this.deployments.remove(this.deploymentID)).eventually(this.deployment::cleanup);
            return undeployingContext.future(p -> undeployFutures.onComplete(ar -> {
                if (ar.succeeded()) {
                    p.complete();
                } else {
                    p.fail(ar.cause());
                }
            }));
        }

        @Override
        public synchronized boolean addChild(DeploymentContext deployment) {
            if (this.status == 0) {
                this.children.add(deployment);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeChild(DeploymentContext deployment) {
            return this.children.remove(deployment);
        }

        @Override
        public Deployment deployment() {
            return this.deployment;
        }

        @Override
        public boolean isChild() {
            return this.child;
        }

        @Override
        public String deploymentID() {
            return this.deploymentID;
        }
    }
}

