/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.future.FutureBase;
import io.vertx.core.internal.ContextInternal;
import java.util.ArrayList;
import java.util.Objects;

public class FutureImpl<T>
extends FutureBase<T> {
    private static final Object NULL_VALUE = new Object();
    private Object value;
    private Completable<T> listener;

    protected FutureImpl() {
    }

    protected FutureImpl(ContextInternal context) {
        super(context);
    }

    @Override
    public synchronized T result() {
        return (T)(this.value instanceof CauseHolder ? null : (this.value == NULL_VALUE ? null : this.value));
    }

    @Override
    public synchronized Throwable cause() {
        return this.value instanceof CauseHolder ? ((CauseHolder)this.value).cause : null;
    }

    @Override
    public synchronized boolean succeeded() {
        return this.value != null && !(this.value instanceof CauseHolder);
    }

    @Override
    public synchronized boolean failed() {
        return this.value instanceof CauseHolder;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.value != null;
    }

    @Override
    public Future<T> onSuccess(final Handler<? super T> handler) {
        Objects.requireNonNull(handler, "No null handler accepted");
        this.addListener(new Completable<T>(){

            @Override
            public void complete(T result, Throwable failure) {
                if (failure == null) {
                    try {
                        handler.handle(result);
                    }
                    catch (Throwable t) {
                        if (FutureImpl.this.context != null) {
                            FutureImpl.this.context.reportException(t);
                        }
                        throw t;
                    }
                }
            }
        });
        return this;
    }

    @Override
    public Future<T> onFailure(Handler<? super Throwable> handler) {
        Objects.requireNonNull(handler, "No null handler accepted");
        this.addListener((value, err) -> {
            if (err != null) {
                try {
                    handler.handle(err);
                }
                catch (Throwable t) {
                    if (this.context != null) {
                        this.context.reportException(t);
                    }
                    throw t;
                }
            }
        });
        return this;
    }

    @Override
    public Future<T> onComplete(Handler<? super T> successHandler, Handler<? super Throwable> failureHandler) {
        this.addListener((value, err) -> {
            try {
                if (err == null) {
                    if (successHandler != null) {
                        successHandler.handle((T)value);
                    }
                } else if (failureHandler != null) {
                    failureHandler.handle(err);
                }
            }
            catch (Throwable t) {
                if (this.context != null) {
                    this.context.reportException(t);
                }
                throw t;
            }
        });
        return this;
    }

    @Override
    public Future<T> onComplete(Handler<AsyncResult<T>> handler) {
        Objects.requireNonNull(handler, "No null handler accepted");
        Completable<Object> listener = handler instanceof Completable ? (Completable<Object>)((Object)handler) : (value, err) -> {
            try {
                handler.handle(this);
            }
            catch (Throwable t) {
                if (this.context != null) {
                    this.context.reportException(t);
                }
                throw t;
            }
        };
        this.addListener(listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Completable<T> listener) {
        Object v;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            v = this.value;
            if (v == null) {
                if (this.listener == null) {
                    this.listener = listener;
                } else {
                    ListenerArray listeners;
                    if (this.listener instanceof ListenerArray) {
                        listeners = (ListenerArray)this.listener;
                    } else {
                        listeners = new ListenerArray();
                        listeners.add(this.listener);
                        this.listener = listeners;
                    }
                    listeners.add(listener);
                }
                return;
            }
        }
        if (v instanceof CauseHolder) {
            this.emitResult(null, ((CauseHolder)v).cause, listener);
        } else {
            if (v == NULL_VALUE) {
                v = null;
            }
            this.emitResult(v, null, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Completable<T> l) {
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            Completable<T> listener = this.listener;
            if (listener == l) {
                this.listener = null;
            } else if (listener instanceof ListenerArray) {
                ListenerArray listeners = (ListenerArray)listener;
                listeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean handleInternal(T result, Throwable err) {
        Completable<T> l;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.value != null) {
                return false;
            }
            this.value = err != null ? new CauseHolder(err) : (result == null ? NULL_VALUE : result);
            l = this.listener;
            this.listener = null;
        }
        if (l != null) {
            this.emitResult(result, err, l);
        }
        return true;
    }

    public final boolean tryComplete(T result) {
        return this.handleInternal(result, null);
    }

    public final boolean tryFail(Throwable cause) {
        if (cause == null) {
            cause = new NoStackTraceThrowable(null);
        }
        return this.handleInternal(null, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.value instanceof CauseHolder) {
                return "Future{cause=" + ((CauseHolder)this.value).cause.getMessage() + "}";
            }
            if (this.value != null) {
                if (this.value == NULL_VALUE) {
                    return "Future{result=null}";
                }
                StringBuilder sb = new StringBuilder("Future{result=");
                this.formatValue(this.value, sb);
                sb.append("}");
                return sb.toString();
            }
            return "Future{unresolved}";
        }
    }

    protected void formatValue(Object value, StringBuilder sb) {
        sb.append(value);
    }

    private static class CauseHolder {
        private final Throwable cause;

        CauseHolder(Throwable cause) {
            this.cause = cause;
        }
    }

    private static class ListenerArray<T>
    extends ArrayList<Completable<T>>
    implements Completable<T> {
        private ListenerArray() {
        }

        @Override
        public void complete(T result, Throwable failure) {
            for (Completable handler : this) {
                handler.complete(result, failure);
            }
        }
    }
}

