/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.dns.impl.DnsAddressResolverProvider;
import io.vertx.core.impl.FailoverCompleteHandler;
import io.vertx.core.impl.HAManager;
import io.vertx.core.impl.HostnameResolver;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.WorkerExecutorInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.deployment.DeploymentContext;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.threadchecker.BlockedThreadChecker;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.NetServerInternal;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.file.FileResolver;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.spi.transport.Transport;
import java.io.File;
import java.lang.ref.Cleaner;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public interface VertxInternal
extends Vertx {
    public static String version() {
        return VertxImpl.version();
    }

    default public <T> Future<T> future(Handler<Promise<T>> handler) {
        return this.getOrCreateContext().future(handler);
    }

    default public <T> PromiseInternal<T> promise() {
        return this.getOrCreateContext().promise();
    }

    default public <T> PromiseInternal<T> promise(Promise<T> p) {
        PromiseInternal<T> promise;
        if (p instanceof PromiseInternal && (promise = (PromiseInternal<T>)p).context() != null) {
            return promise;
        }
        promise = this.promise();
        promise.future().onComplete(p);
        return promise;
    }

    @Override
    default public void runOnContext(Handler<Void> task) {
        ContextInternal context = this.getOrCreateContext();
        context.runOnContext(task);
    }

    public long maxEventLoopExecTime();

    public TimeUnit maxEventLoopExecTimeUnit();

    @Override
    public NetServerInternal createNetServer(NetServerOptions var1);

    @Override
    default public NetServerInternal createNetServer() {
        return this.createNetServer(new NetServerOptions());
    }

    @Override
    public ContextInternal getOrCreateContext();

    public EventLoopGroup getEventLoopGroup();

    public EventLoopGroup getAcceptorEventLoopGroup();

    public WorkerPool getWorkerPool();

    public WorkerPool getInternalWorkerPool();

    public Map<ServerID, NetServerInternal> sharedTcpServers();

    public VertxMetrics metricsSPI();

    public Transport transport();

    public Cleaner cleaner();

    public <C> C createSharedResource(String var1, String var2, CloseFuture var3, Function<CloseFuture, C> var4);

    public ContextInternal getContext();

    public ContextInternal createContext(ThreadingModel var1, EventLoop var2, CloseFuture var3, WorkerPool var4, DeploymentContext var5, ClassLoader var6);

    default public ContextInternal createContext(ThreadingModel threadingModel, DeploymentContext deployment, CloseFuture closeFuture, WorkerPool workerPool, ClassLoader tccl) {
        return this.createContext(threadingModel, this.nettyEventLoopGroup().next(), closeFuture, workerPool, deployment, tccl);
    }

    default public ContextInternal createContext(ThreadingModel threadingModel, EventLoop eventLoop, WorkerPool workerPool, ClassLoader tccl) {
        return this.createContext(threadingModel, eventLoop, this.closeFuture(), workerPool, null, tccl);
    }

    default public ContextInternal createContext(ThreadingModel threadingModel) {
        return this.createContext(threadingModel, null, this.closeFuture(), null, Thread.currentThread().getContextClassLoader());
    }

    default public ContextInternal createEventLoopContext(DeploymentContext deployment, CloseFuture closeFuture, WorkerPool workerPool, ClassLoader tccl) {
        return this.createContext(ThreadingModel.EVENT_LOOP, deployment, closeFuture, workerPool, tccl);
    }

    default public ContextInternal createEventLoopContext(EventLoop eventLoop, WorkerPool workerPool, ClassLoader tccl) {
        return this.createContext(ThreadingModel.EVENT_LOOP, eventLoop, workerPool, tccl);
    }

    default public ContextInternal createEventLoopContext() {
        return this.createContext(ThreadingModel.EVENT_LOOP);
    }

    default public ContextInternal createWorkerContext(DeploymentContext deployment, CloseFuture closeFuture, EventLoop eventLoop, WorkerPool workerPool, ClassLoader tccl) {
        return this.createContext(ThreadingModel.WORKER, eventLoop, closeFuture, workerPool, deployment, tccl);
    }

    default public ContextInternal createWorkerContext(DeploymentContext deployment, CloseFuture closeFuture, WorkerPool workerPool, ClassLoader tccl) {
        return this.createContext(ThreadingModel.WORKER, deployment, closeFuture, workerPool, tccl);
    }

    default public ContextInternal createWorkerContext(EventLoop eventLoop, WorkerPool workerPool, ClassLoader tccl) {
        return this.createContext(ThreadingModel.WORKER, eventLoop, workerPool, tccl);
    }

    default public ContextInternal createWorkerContext() {
        return this.createContext(ThreadingModel.WORKER);
    }

    default public ContextInternal createVirtualThreadContext(DeploymentContext deployment, CloseFuture closeFuture, EventLoop eventLoop, ClassLoader tccl) {
        return this.createContext(ThreadingModel.VIRTUAL_THREAD, eventLoop, closeFuture, null, deployment, tccl);
    }

    default public ContextInternal createVirtualThreadContext(DeploymentContext deployment, CloseFuture closeFuture, ClassLoader tccl) {
        return this.createContext(ThreadingModel.VIRTUAL_THREAD, deployment, closeFuture, null, tccl);
    }

    default public ContextInternal createVirtualThreadContext(EventLoop eventLoop, ClassLoader tccl) {
        return this.createContext(ThreadingModel.VIRTUAL_THREAD, eventLoop, null, tccl);
    }

    default public ContextInternal createVirtualThreadContext() {
        return this.createContext(ThreadingModel.VIRTUAL_THREAD);
    }

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1);

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1, int var2);

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1, int var2, long var3);

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1, int var2, long var3, TimeUnit var5);

    public WorkerPool createSharedWorkerPool(String var1, int var2, long var3, TimeUnit var5);

    public WorkerPool wrapWorkerPool(ExecutorService var1);

    public void simulateKill();

    public DeploymentContext getDeployment(String var1);

    public void failoverCompleteHandler(FailoverCompleteHandler var1);

    public boolean isKilled();

    public void failDuringFailover(boolean var1);

    public File resolveFile(String var1);

    default public <T> Future<T> executeBlockingInternal(Callable<T> blockingCodeHandler) {
        ContextInternal context = this.getOrCreateContext();
        return context.executeBlockingInternal(blockingCodeHandler);
    }

    public ClusterManager getClusterManager();

    public HAManager haManager();

    public Future<InetAddress> resolveAddress(String var1);

    public HostnameResolver hostnameResolver();

    public DnsAddressResolverProvider dnsAddressResolverProvider(InetSocketAddress var1);

    public FileResolver fileResolver();

    public EventLoopGroup nettyEventLoopGroup();

    public AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup();

    public BlockedThreadChecker blockedThreadChecker();

    public CloseFuture closeFuture();

    public VertxTracer tracer();

    public void addCloseHook(Closeable var1);

    public void removeCloseHook(Closeable var1);

    public boolean isVirtualThreadAvailable();
}

