/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams.impl;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.impl.Arguments;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Predicate;

public abstract class InboundReadQueue<E> {
    public static final Factory SPSC = new Factory(){

        public <T> InboundReadQueue<T> create(Predicate<T> consumer, int lowWaterMark, int highWaterMark) {
            return new SpSc<T>(consumer, lowWaterMark, highWaterMark);
        }

        public <T> InboundReadQueue<T> create(Predicate<T> consumer) {
            return new SpSc<T>(consumer);
        }
    };
    public static final Factory SINGLE_THREADED = new Factory(){

        public <T> InboundReadQueue<T> create(Predicate<T> consumer, int lowWaterMark, int highWaterMark) {
            return new SingleThread<T>(consumer, lowWaterMark, highWaterMark);
        }

        public <T> InboundReadQueue<T> create(Predicate<T> consumer) {
            return new SingleThread<T>(consumer);
        }
    };
    public static final int DEFAULT_HIGH_WATER_MARK = 16;
    public static final int DEFAULT_LOW_WATER_MARK = 8;
    public static final int DRAIN_REQUIRED_MASK = 1;
    public static final int QUEUE_UNWRITABLE_MASK = 2;
    public static final int QUEUE_WRITABLE_MASK = 2;
    private final long highWaterMark;
    private final long lowWaterMark;
    private final Queue<E> queue;
    private final Predicate<E> consumer;
    private E overflow;
    private int writeQueueFull;

    public static int numberOfPendingElements(int value) {
        return (value & 0xFFFFFFFC) >> 2;
    }

    public static int drainResult(int num, boolean writable) {
        return (writable ? 2 : 0) | (num > 0 ? 1 : 0) | num << 2;
    }

    private InboundReadQueue(Queue<E> queue, Predicate<E> consumer, int lowWaterMark, int highWaterMark) {
        Arguments.require(lowWaterMark >= 0, "The low-water mark must be >= 0");
        Arguments.require(lowWaterMark <= highWaterMark, "The high-water mark must greater or equals to the low-water mark");
        this.queue = queue;
        this.lowWaterMark = lowWaterMark;
        this.highWaterMark = highWaterMark;
        this.consumer = Objects.requireNonNull(consumer);
    }

    protected abstract boolean wipCompareAndSet(long var1, long var3);

    protected abstract long wipIncrementAndGet();

    protected abstract long wipDecrementAndGet();

    protected abstract long wipGet();

    protected abstract long wipAddAndGet(long var1);

    public long highWaterMark() {
        return this.highWaterMark;
    }

    public long lowWaterMark() {
        return this.lowWaterMark;
    }

    public int add(E element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.wipCompareAndSet(0L, 1L)) {
            this.overflow = element;
            return 1;
        }
        this.queue.offer(element);
        long val = this.wipIncrementAndGet();
        if (val != 1L) {
            return val == this.highWaterMark ? 2 : 0;
        }
        return 1;
    }

    public int drain() {
        return this.drain(Long.MAX_VALUE);
    }

    public int drain(long maxIter) {
        boolean writabilityChanged;
        int consumed;
        if (maxIter < 0L) {
            throw new IllegalArgumentException();
        }
        if (maxIter == 0L) {
            return 0;
        }
        E elt = this.overflow;
        if (elt != null) {
            if (!this.consumer.test(elt)) {
                return InboundReadQueue.drainResult((int)this.wipGet(), false);
            }
            this.overflow = null;
            if (this.consume(1) == 0L) {
                return InboundReadQueue.drainResult(0, false);
            }
            if (maxIter != Long.MAX_VALUE) {
                --maxIter;
            }
        }
        long pending = this.wipGet();
        block0: do {
            consumed = 0;
            while ((long)consumed < pending && maxIter > 0L) {
                elt = this.queue.poll();
                if (maxIter != Long.MAX_VALUE) {
                    --maxIter;
                }
                if (!this.consumer.test(elt)) {
                    this.overflow = elt;
                    continue block0;
                }
                ++consumed;
            }
        } while ((pending = this.consume(consumed)) != 0L && this.overflow == null && maxIter > 0L);
        boolean bl = writabilityChanged = pending < this.lowWaterMark && this.writeQueueFull > 0;
        if (writabilityChanged) {
            this.writeQueueFull = 0;
        }
        return InboundReadQueue.drainResult((int)pending, writabilityChanged);
    }

    private long consume(int amount) {
        long pending = this.wipAddAndGet(-amount);
        long size = pending + (long)amount;
        if (size >= this.highWaterMark && size - (long)amount < this.highWaterMark) {
            ++this.writeQueueFull;
        }
        return pending;
    }

    private static class SpSc<E>
    extends InboundReadQueue<E> {
        private static final AtomicLongFieldUpdater<SpSc<?>> WIP_UPDATER = AtomicLongFieldUpdater.newUpdater(SpSc.class, "wip");
        private volatile long wip;

        public SpSc(Predicate<E> consumer) {
            this(consumer, 8, 16);
        }

        public SpSc(Predicate<E> consumer, int lowWaterMark, int highWaterMark) {
            super(PlatformDependent.newSpscQueue(), consumer, lowWaterMark, highWaterMark);
        }

        @Override
        protected boolean wipCompareAndSet(long expect, long update) {
            return WIP_UPDATER.compareAndSet(this, expect, update);
        }

        @Override
        protected long wipIncrementAndGet() {
            return WIP_UPDATER.incrementAndGet(this);
        }

        @Override
        protected long wipDecrementAndGet() {
            return WIP_UPDATER.decrementAndGet(this);
        }

        @Override
        protected long wipGet() {
            return WIP_UPDATER.get(this);
        }

        @Override
        protected long wipAddAndGet(long delta) {
            return WIP_UPDATER.addAndGet(this, delta);
        }
    }

    private static class SingleThread<E>
    extends InboundReadQueue<E> {
        private long wip;

        public SingleThread(Predicate<E> consumer) {
            this(consumer, 8, 16);
        }

        public SingleThread(Predicate<E> consumer, int lowWaterMark, int highWaterMark) {
            super(new ArrayDeque(1), consumer, lowWaterMark, highWaterMark);
        }

        @Override
        protected boolean wipCompareAndSet(long expect, long update) {
            if (this.wip == expect) {
                this.wip = update;
                return true;
            }
            return false;
        }

        @Override
        protected long wipIncrementAndGet() {
            return ++this.wip;
        }

        @Override
        protected long wipDecrementAndGet() {
            return --this.wip;
        }

        @Override
        protected long wipGet() {
            return this.wip;
        }

        @Override
        protected long wipAddAndGet(long delta) {
            return this.wip += delta;
        }
    }

    public static interface Factory {
        public <E> InboundReadQueue<E> create(Predicate<E> var1, int var2, int var3);

        public <E> InboundReadQueue<E> create(Predicate<E> var1);
    }
}

