/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Handler;
import io.vertx.core.ThreadingModel;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.impl.Http1xOrH2CHandler;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.Http1xUpgradeToH2CHandler;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import io.vertx.core.http.impl.VertxHttpRequestDecoder;
import io.vertx.core.http.impl.VertxHttpResponseEncoder;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.SslChannelProvider;
import io.vertx.core.internal.tls.SslContextManager;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

class HttpServerConnectionInitializer {
    private final ContextInternal context;
    private final ThreadingModel threadingModel;
    private final Supplier<ContextInternal> streamContextSupplier;
    private final VertxInternal vertx;
    private final HttpServerImpl server;
    private final HttpServerOptions options;
    private final String serverOrigin;
    private final boolean logEnabled;
    private final boolean disableH2C;
    private final Handler<HttpServerConnection> connectionHandler;
    private final Handler<Throwable> exceptionHandler;
    private final Object metric;
    private final CompressionOptions[] compressionOptions;
    private final int compressionContentSizeThreshold;
    private final Function<String, String> encodingDetector;

    HttpServerConnectionInitializer(ContextInternal context, ThreadingModel threadingModel, Supplier<ContextInternal> streamContextSupplier, HttpServerImpl server, VertxInternal vertx, HttpServerOptions options, String serverOrigin, Handler<HttpServerConnection> connectionHandler, Handler<Throwable> exceptionHandler, Object metric) {
        CompressionOptions[] compressionOptions = null;
        if (options.isCompressionSupported()) {
            List<CompressionOptions> compressors = options.getCompressors();
            if (compressors == null) {
                int compressionLevel = options.getCompressionLevel();
                compressionOptions = new CompressionOptions[]{StandardCompressionOptions.gzip((int)compressionLevel, (int)15, (int)8), StandardCompressionOptions.deflate((int)compressionLevel, (int)15, (int)8)};
            } else {
                compressionOptions = compressors.toArray(new CompressionOptions[0]);
            }
        }
        this.context = context;
        this.threadingModel = threadingModel;
        this.streamContextSupplier = streamContextSupplier;
        this.server = server;
        this.vertx = vertx;
        this.options = options;
        this.serverOrigin = serverOrigin;
        this.logEnabled = options.getLogActivity();
        this.disableH2C = !options.isHttp2ClearTextEnabled();
        this.connectionHandler = connectionHandler;
        this.exceptionHandler = exceptionHandler;
        this.metric = metric;
        this.compressionOptions = compressionOptions;
        this.compressionContentSizeThreshold = options.getCompressionContentSizeThreshold();
        this.encodingDetector = compressionOptions != null ? new EncodingDetector(options.getCompressionContentSizeThreshold(), compressionOptions)::determineEncoding : null;
    }

    void configurePipeline(Channel ch, final SslChannelProvider sslChannelProvider, final SslContextManager sslContextManager) {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.options.isSsl()) {
            SslHandler sslHandler = (SslHandler)pipeline.get(SslHandler.class);
            if (this.options.isUseAlpn()) {
                String protocol = sslHandler.applicationProtocol();
                if (protocol != null) {
                    switch (protocol) {
                        case "h2": {
                            this.configureHttp2(ch.pipeline());
                            break;
                        }
                        case "http/1.1": 
                        case "http/1.0": {
                            this.configureHttp1Pipeline(ch.pipeline(), sslChannelProvider, sslContextManager);
                            this.configureHttp1Handler(ch.pipeline(), sslChannelProvider, sslContextManager);
                        }
                    }
                } else {
                    this.configureHttp1Pipeline(ch.pipeline(), sslChannelProvider, sslContextManager);
                    this.configureHttp1Handler(ch.pipeline(), sslChannelProvider, sslContextManager);
                }
            } else {
                this.configureHttp1Pipeline(ch.pipeline(), sslChannelProvider, sslContextManager);
                this.configureHttp1Handler(ch.pipeline(), sslChannelProvider, sslContextManager);
            }
        } else if (this.disableH2C) {
            this.configureHttp1Pipeline(ch.pipeline(), sslChannelProvider, sslContextManager);
            this.configureHttp1Handler(ch.pipeline(), sslChannelProvider, sslContextManager);
        } else {
            Http1xOrH2CHandler handler = new Http1xOrH2CHandler(){

                @Override
                protected void configure(ChannelHandlerContext ctx, boolean h2c) {
                    if (h2c) {
                        HttpServerConnectionInitializer.this.configureHttp2(ctx.pipeline());
                    } else {
                        HttpServerConnectionInitializer.this.configureHttp1Pipeline(ctx.pipeline(), sslChannelProvider, sslContextManager);
                        HttpServerConnectionInitializer.this.configureHttp1OrH2CUpgradeHandler(ctx.pipeline(), sslChannelProvider, sslContextManager);
                    }
                }

                @Override
                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    super.exceptionCaught(ctx, cause);
                    HttpServerConnectionInitializer.this.handleException(cause);
                }
            };
            String name = HttpServerConnectionInitializer.computeChannelName(pipeline);
            pipeline.addBefore(name, null, (ChannelHandler)handler);
        }
    }

    private void handleException(Throwable cause) {
        this.context.emit(cause, this.exceptionHandler);
    }

    private void sendServiceUnavailable(Channel ch) {
        ch.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 503 Service Unavailable\r\nContent-Length:0\r\n\r\n", (Charset)StandardCharsets.ISO_8859_1)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void configureHttp2(ChannelPipeline pipeline) {
        this.configureHttp2Handler(pipeline);
        this.configureHttp2Pipeline(pipeline);
    }

    private void configureHttp2Handler(ChannelPipeline pipeline) {
        VertxHttp2ConnectionHandler<Http2ServerConnection> handler = this.buildHttp2ConnectionHandler(this.context, this.connectionHandler);
        pipeline.replace(VertxHandler.class, "handler", handler);
    }

    void configureHttp2Pipeline(ChannelPipeline pipeline) {
        if (!this.server.requestAccept()) {
            pipeline.channel().close();
            return;
        }
    }

    VertxHttp2ConnectionHandler<Http2ServerConnection> buildHttp2ConnectionHandler() {
        return this.buildHttp2ConnectionHandler(this.context, this.connectionHandler);
    }

    private VertxHttp2ConnectionHandler<Http2ServerConnection> buildHttp2ConnectionHandler(ContextInternal ctx, Handler<HttpServerConnection> handler_) {
        HttpServerMetrics metrics = (HttpServerMetrics)this.server.getMetrics();
        int maxRstFramesPerWindow = this.options.getHttp2RstFloodMaxRstFramePerWindow();
        int secondsPerWindow = (int)this.options.getHttp2RstFloodWindowDurationTimeUnit().toSeconds(this.options.getHttp2RstFloodWindowDuration());
        Http2ConnectionHandler handler = new VertxHttp2ConnectionHandlerBuilder().server(true).useCompression(this.compressionOptions).gracefulShutdownTimeoutMillis(0L).decoderEnforceMaxRstFramesPerWindow(maxRstFramesPerWindow, secondsPerWindow).useDecompression(this.options.isDecompressionSupported()).initialSettings(this.options.getInitialSettings()).connectionFactory(connHandler -> {
            Http2ServerConnection conn = new Http2ServerConnection(ctx, this.streamContextSupplier, this.serverOrigin, (VertxHttp2ConnectionHandler)((Object)connHandler), this.encodingDetector, this.options, metrics);
            conn.metric(this.metric);
            return conn;
        }).logEnabled(this.logEnabled).build();
        handler.addHandler(conn -> {
            if (this.options.getHttp2ConnectionWindowSize() > 0) {
                conn.setWindowSize(this.options.getHttp2ConnectionWindowSize());
            }
            handler_.handle((HttpServerConnection)conn);
        });
        return handler;
    }

    private void configureHttp1OrH2CUpgradeHandler(ChannelPipeline pipeline, SslChannelProvider sslChannelProvider, SslContextManager sslContextManager) {
        pipeline.addAfter("httpEncoder", "h2c", (ChannelHandler)new Http1xUpgradeToH2CHandler(this, sslChannelProvider, sslContextManager, this.options.isCompressionSupported(), this.options.isDecompressionSupported()));
    }

    private static String computeChannelName(ChannelPipeline pipeline) {
        if (pipeline.get(ChunkedWriteHandler.class) != null) {
            return "chunkedWriter";
        }
        if (pipeline.get(IdleStateHandler.class) != null) {
            return "idle";
        }
        return "handler";
    }

    private void configureHttp1Pipeline(ChannelPipeline pipeline, SslChannelProvider sslChannelProvider, SslContextManager sslContextManager) {
        String name = HttpServerConnectionInitializer.computeChannelName(pipeline);
        pipeline.addBefore(name, "httpDecoder", (ChannelHandler)new VertxHttpRequestDecoder(this.options));
        pipeline.addBefore(name, "httpEncoder", (ChannelHandler)new VertxHttpResponseEncoder());
        if (this.options.isDecompressionSupported()) {
            pipeline.addBefore(name, "inflater", (ChannelHandler)new HttpContentDecompressor(false));
        }
        if (this.options.isCompressionSupported()) {
            pipeline.addBefore(name, "deflater", (ChannelHandler)new HttpChunkContentCompressor(this.compressionContentSizeThreshold, this.compressionOptions));
        }
    }

    void configureHttp1Handler(ChannelPipeline pipeline, SslChannelProvider sslChannelProvider, SslContextManager sslContextManager) {
        if (!this.server.requestAccept()) {
            this.sendServiceUnavailable(pipeline.channel());
            return;
        }
        HttpServerMetrics metrics = (HttpServerMetrics)this.server.getMetrics();
        VertxHandler<Http1xServerConnection> handler = VertxHandler.create(chctx -> {
            Http1xServerConnection conn = new Http1xServerConnection(this.threadingModel, this.streamContextSupplier, sslContextManager, this.options, (ChannelHandlerContext)chctx, this.context, this.serverOrigin, metrics);
            conn.metric(this.metric);
            return conn;
        });
        pipeline.replace(VertxHandler.class, "handler", handler);
        Http1xServerConnection conn = handler.getConnection();
        this.connectionHandler.handle(conn);
    }

    private static class EncodingDetector
    extends HttpContentCompressor {
        private EncodingDetector(int contentSizeThreshold, CompressionOptions[] compressionOptions) {
            super(contentSizeThreshold, compressionOptions);
        }

        protected String determineEncoding(String acceptEncoding) {
            return super.determineEncoding(acceptEncoding);
        }
    }
}

