/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal;

import io.netty.channel.EventLoopGroup;
import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextBuilder;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.WorkerExecutorInternal;
import io.vertx.core.internal.WorkerPool;
import io.vertx.core.internal.deployment.DeploymentManager;
import io.vertx.core.internal.resolver.NameResolver;
import io.vertx.core.internal.threadchecker.BlockedThreadChecker;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.NetServerInternal;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.context.storage.ContextLocal;
import io.vertx.core.spi.file.FileResolver;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.spi.transport.Transport;
import java.lang.ref.Cleaner;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public interface VertxInternal
extends Vertx {
    public static String version() {
        return VertxImpl.version();
    }

    default public <T> Future<T> future(Handler<Promise<T>> handler) {
        return this.getOrCreateContext().future(handler);
    }

    default public <T> PromiseInternal<T> promise() {
        return this.getOrCreateContext().promise();
    }

    default public <T> PromiseInternal<T> promise(Completable<T> p) {
        PromiseInternal<T> promise;
        if (p instanceof PromiseInternal && (promise = (PromiseInternal<T>)p).context() != null) {
            return promise;
        }
        promise = this.promise();
        promise.future().onComplete(p);
        return promise;
    }

    @Override
    default public void runOnContext(Handler<Void> task) {
        ContextInternal context = this.getOrCreateContext();
        context.runOnContext(task);
    }

    @Override
    public NetServerInternal createNetServer(NetServerOptions var1);

    @Override
    default public NetServerInternal createNetServer() {
        return this.createNetServer(new NetServerOptions());
    }

    @Override
    public ContextInternal getOrCreateContext();

    public EventLoopGroup eventLoopGroup();

    public EventLoopGroup acceptorEventLoopGroup();

    public WorkerPool workerPool();

    public WorkerPool internalWorkerPool();

    public Map<ServerID, NetServerInternal> sharedTcpServers();

    public VertxMetrics metrics();

    public Transport transport();

    public Cleaner cleaner();

    public <C> C createSharedResource(String var1, String var2, CloseFuture var3, Function<CloseFuture, C> var4);

    public ContextInternal getContext();

    public ContextBuilder contextBuilder();

    default public ContextInternal createContext(ThreadingModel threadingModel) {
        return this.contextBuilder().withThreadingModel(threadingModel).build();
    }

    default public ContextInternal createEventLoopContext() {
        return this.createContext(ThreadingModel.EVENT_LOOP);
    }

    default public ContextInternal createWorkerContext() {
        return this.createContext(ThreadingModel.WORKER);
    }

    default public ContextInternal createVirtualThreadContext() {
        return this.createContext(ThreadingModel.VIRTUAL_THREAD);
    }

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1);

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1, int var2);

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1, int var2, long var3);

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1, int var2, long var3, TimeUnit var5);

    public WorkerPool createSharedWorkerPool(String var1, int var2, long var3, TimeUnit var5);

    public WorkerPool wrapWorkerPool(ExecutorService var1);

    default public <T> Future<T> executeBlockingInternal(Callable<T> blockingCodeHandler) {
        ContextInternal context = this.getOrCreateContext();
        return context.executeBlockingInternal(blockingCodeHandler);
    }

    public ClusterManager clusterManager();

    public DeploymentManager deploymentManager();

    public NameResolver nameResolver();

    public FileResolver fileResolver();

    public EventLoopGroup nettyEventLoopGroup();

    public List<ContextLocal<?>> contextLocals();

    public BlockedThreadChecker blockedThreadChecker();

    public CloseFuture closeFuture();

    public VertxTracer<?, ?> tracer();

    public void addCloseHook(Closeable var1);

    public void removeCloseHook(Closeable var1);

    public boolean isVirtualThreadAvailable();
}

