/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.buffer.VertxByteBufAllocator;
import io.vertx.core.internal.CloseSequence;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.SslChannelProvider;
import io.vertx.core.internal.net.SslHandshakeCompletionHandler;
import io.vertx.core.internal.resolver.NameResolver;
import io.vertx.core.internal.tls.SslContextManager;
import io.vertx.core.internal.tls.SslContextProvider;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.ServerSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.core.net.impl.HAProxyMessageCompletionHandler;
import io.vertx.core.net.impl.NetServerInternal;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.ServerChannelLoadBalancer;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.ShutdownEvent;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class NetServerImpl
implements Closeable,
MetricsProvider,
NetServerInternal {
    private static final Logger log = LoggerFactory.getLogger(NetServerImpl.class);
    private final VertxInternal vertx;
    private final NetServerOptions options;
    private final CloseSequence closeSequence;
    private Handler<NetSocket> handler;
    private Handler<Throwable> exceptionHandler;
    private EventLoop eventLoop;
    private NetSocketInitializer initializer;
    private ChannelGroup channelGroup;
    private Handler<Channel> worker;
    private volatile boolean listening;
    private ContextInternal listenContext;
    private NetServerImpl actualServer;
    private ShutdownEvent closeEvent;
    private ChannelGroupFuture graceFuture;
    private SslContextManager sslContextManager;
    private volatile Future<SslContextProvider> sslContextProvider;
    private Future<SslContextProvider> updateInProgress;
    private GlobalTrafficShapingHandler trafficShapingHandler;
    private ServerChannelLoadBalancer channelBalancer;
    private Future<Channel> bindFuture;
    private TCPMetrics<?> metrics;
    private volatile int actualPort;

    public NetServerImpl(VertxInternal vertx, NetServerOptions options) {
        CloseSequence closeSequence = new CloseSequence(completion -> this.doClose(completion), completion1 -> this.doGrace(completion1), completion2 -> this.doShutdown(completion2));
        this.vertx = vertx;
        this.options = options;
        this.closeSequence = closeSequence;
    }

    @Override
    public SslContextProvider sslContextProvider() {
        return this.sslContextProvider.result();
    }

    @Override
    public synchronized Handler<NetSocket> connectHandler() {
        return this.handler;
    }

    @Override
    public synchronized NetServerInternal connectHandler(Handler<NetSocket> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set connectHandler when server is listening");
        }
        this.handler = handler;
        return this;
    }

    @Override
    public synchronized NetServerInternal exceptionHandler(Handler<Throwable> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set exceptionHandler when server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public int actualPort() {
        NetServerImpl server = this.actualServer;
        return server != null ? server.actualPort : this.actualPort;
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        this.closeEvent = new ShutdownEvent(timeout, unit);
        return this.closeSequence.close();
    }

    @Override
    public Future<NetServer> listen(SocketAddress localAddress) {
        return this.listen(this.vertx.getOrCreateContext(), localAddress);
    }

    @Override
    public Future<NetServer> listen(ContextInternal context, SocketAddress localAddress) {
        if (localAddress == null) {
            throw new NullPointerException("No null bind local address");
        }
        if (this.handler == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        return this.bind(context, localAddress).map(this);
    }

    @Override
    public Future<NetServer> listen() {
        return this.listen(this.options.getPort(), this.options.getHost());
    }

    @Override
    public synchronized void close(Completable<Void> completion) {
        this.shutdown(0L, TimeUnit.SECONDS).onComplete(completion);
    }

    public boolean isClosed() {
        return !this.isListening();
    }

    protected void initChannel(ChannelPipeline pipeline, boolean ssl) {
        if (this.options.getLogActivity()) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(this.options.getActivityLogDataFormat()));
        }
        int idleTimeout = this.options.getIdleTimeout();
        int readIdleTimeout = this.options.getReadIdleTimeout();
        int writeIdleTimeout = this.options.getWriteIdleTimeout();
        if (idleTimeout > 0 || readIdleTimeout > 0 || writeIdleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler((long)readIdleTimeout, (long)writeIdleTimeout, (long)idleTimeout, this.options.getIdleTimeoutUnit()));
        }
        if (ssl || !this.options.isFileRegionEnabled() || !this.vertx.transport().supportFileRegion() || this.options.getTrafficShapingOptions() != null && this.options.getTrafficShapingOptions().getOutboundGlobalBandwidth() > 0L) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
    }

    protected GlobalTrafficShapingHandler createTrafficShapingHandler() {
        return this.createTrafficShapingHandler(this.vertx.eventLoopGroup(), this.options.getTrafficShapingOptions());
    }

    private GlobalTrafficShapingHandler createTrafficShapingHandler(EventLoopGroup eventLoopGroup, TrafficShapingOptions options) {
        GlobalTrafficShapingHandler trafficShapingHandler;
        if (options == null) {
            return null;
        }
        if (options.getMaxDelayToWait() != 0L) {
            long maxDelayToWaitInMillis = options.getMaxDelayToWaitTimeUnit().toMillis(options.getMaxDelayToWait());
            long checkIntervalForStatsInMillis = options.getCheckIntervalForStatsTimeUnit().toMillis(options.getCheckIntervalForStats());
            trafficShapingHandler = new GlobalTrafficShapingHandler((ScheduledExecutorService)eventLoopGroup, options.getOutboundGlobalBandwidth(), options.getInboundGlobalBandwidth(), checkIntervalForStatsInMillis, maxDelayToWaitInMillis);
        } else {
            long checkIntervalForStatsInMillis = options.getCheckIntervalForStatsTimeUnit().toMillis(options.getCheckIntervalForStats());
            trafficShapingHandler = new GlobalTrafficShapingHandler((ScheduledExecutorService)eventLoopGroup, options.getOutboundGlobalBandwidth(), options.getInboundGlobalBandwidth(), checkIntervalForStatsInMillis);
        }
        if (options.getPeakOutboundGlobalBandwidth() != 0L) {
            trafficShapingHandler.setMaxGlobalWriteSize(options.getPeakOutboundGlobalBandwidth());
        }
        return trafficShapingHandler;
    }

    protected void configure(SSLOptions options) {
    }

    public int sniEntrySize() {
        return this.sslContextManager.sniEntrySize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Boolean> updateSSLOptions(ServerSSLOptions options, boolean force) {
        Future<SslContextProvider> fut;
        SslContextProvider current;
        NetServerImpl server = this.actualServer;
        if (server != null && server != this) {
            return server.updateSSLOptions(options, force);
        }
        ContextInternal ctx = this.vertx.getOrCreateContext();
        NetServerImpl netServerImpl = this;
        synchronized (netServerImpl) {
            ClientAuth clientAuth;
            ServerSSLOptions sslOptions;
            current = this.sslContextProvider.result();
            if (this.updateInProgress == null) {
                sslOptions = options.copy();
                this.configure(sslOptions);
                clientAuth = sslOptions.getClientAuth();
                if (clientAuth == null) {
                    clientAuth = ClientAuth.NONE;
                }
            } else {
                return this.updateInProgress.mapEmpty().transform(ar -> this.updateSSLOptions(options, force));
            }
            fut = this.updateInProgress = this.sslContextManager.resolveSslContextProvider(sslOptions, null, clientAuth, sslOptions.getApplicationLayerProtocols(), force, ctx);
        }
        fut.onComplete(ar -> {
            NetServerImpl netServerImpl = this;
            synchronized (netServerImpl) {
                this.updateInProgress = null;
                if (ar.succeeded()) {
                    this.sslContextProvider = fut;
                }
            }
        });
        return fut.map(res -> res != current);
    }

    @Override
    public Future<Boolean> updateTrafficShapingOptions(TrafficShapingOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Invalid null value passed for traffic shaping options update");
        }
        NetServerImpl server = this.actualServer;
        ContextInternal ctx = this.vertx.getOrCreateContext();
        if (server == null) {
            TrafficShapingOptions prev = this.options.getTrafficShapingOptions();
            boolean updated = prev == null || !prev.equals(options);
            this.options.setTrafficShapingOptions(options);
            return ctx.succeededFuture(updated);
        }
        if (server != this) {
            return server.updateTrafficShapingOptions(options);
        }
        PromiseInternal promise = ctx.promise();
        ctx.emit(v -> this.updateTrafficShapingOptions(options, promise));
        return promise.future();
    }

    public void updateTrafficShapingOptions(TrafficShapingOptions options, Promise<Boolean> promise) {
        if (this.trafficShapingHandler == null) {
            promise.fail(new IllegalStateException("Unable to update traffic shaping options because the server was not configured to use traffic shaping during startup"));
        } else if (!options.equals(this.options.getTrafficShapingOptions())) {
            this.options.setTrafficShapingOptions(options);
            long checkIntervalForStatsInMillis = options.getCheckIntervalForStatsTimeUnit().toMillis(options.getCheckIntervalForStats());
            this.trafficShapingHandler.configure(options.getOutboundGlobalBandwidth(), options.getInboundGlobalBandwidth(), checkIntervalForStatsInMillis);
            if (options.getPeakOutboundGlobalBandwidth() != 0L) {
                this.trafficShapingHandler.setMaxGlobalWriteSize(options.getPeakOutboundGlobalBandwidth());
            }
            if (options.getMaxDelayToWait() != 0L) {
                long maxDelayToWaitInMillis = options.getMaxDelayToWaitTimeUnit().toMillis(options.getMaxDelayToWait());
                this.trafficShapingHandler.setMaxWriteDelay(maxDelayToWaitInMillis);
            }
            promise.complete(true);
        } else {
            log.info((Object)"Not updating traffic shaping options as they have not changed");
            promise.complete(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Future<Channel> bind(ContextInternal context, SocketAddress localAddress) {
        Map<ServerID, NetServerInternal> sharedNetServers;
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listenContext = context;
        this.listening = true;
        this.eventLoop = context.nettyEventLoop();
        Map<ServerID, NetServerInternal> map = sharedNetServers = this.vertx.sharedTcpServers();
        synchronized (map) {
            SocketAddress bindAddress;
            boolean shared;
            NetServerImpl main;
            ServerID id;
            String hostOrPath;
            this.actualPort = localAddress.port();
            String string = hostOrPath = localAddress.isInetSocket() ? localAddress.host() : localAddress.path();
            if (this.actualPort > 0 || localAddress.isDomainSocket()) {
                id = new ServerID(this.actualPort, hostOrPath);
                main = (NetServerImpl)sharedNetServers.get(id);
                shared = true;
                bindAddress = localAddress;
            } else if (this.actualPort < 0) {
                id = new ServerID(this.actualPort, hostOrPath + "/" + -this.actualPort);
                main = (NetServerImpl)sharedNetServers.get(id);
                shared = true;
                bindAddress = SocketAddress.inetSocketAddress(0, localAddress.host());
            } else {
                id = new ServerID(this.actualPort, hostOrPath);
                main = null;
                shared = false;
                bindAddress = localAddress;
            }
            DefaultChannelGroup group = new DefaultChannelGroup((EventExecutor)this.listenContext.nettyEventLoop(), true);
            this.channelGroup = group;
            PromiseInternal<Channel> promise = this.listenContext.promise();
            if (main == null) {
                SslContextManager helper;
                try {
                    helper = new SslContextManager(SslContextManager.resolveEngineOptions(this.options.getSslEngineOptions(), this.options.isUseAlpn()));
                }
                catch (Exception e) {
                    return context.failedFuture(e);
                }
                this.actualServer = this;
                this.bindFuture = promise;
                this.sslContextManager = helper;
                this.trafficShapingHandler = this.createTrafficShapingHandler();
                this.initializer = new NetSocketInitializer(context, this.handler, this.exceptionHandler, this.trafficShapingHandler);
                this.worker = ch -> {
                    this.channelGroup.add(ch);
                    Future<SslContextProvider> scp = this.sslContextProvider;
                    this.initializer.accept((Channel)ch, scp != null ? scp.result() : null, this.sslContextManager, this.options.getSslOptions());
                };
                this.channelBalancer = new ServerChannelLoadBalancer((EventExecutor)this.vertx.acceptorEventLoopGroup().next());
                if (this.options.isSsl() && this.options.getKeyCertOptions() == null && this.options.getTrustOptions() == null) {
                    return context.failedFuture("Key/certificate is mandatory for SSL");
                }
                if (shared) {
                    sharedNetServers.put(id, this);
                }
                this.listenContext.addCloseHook(this);
                if (this.options.isSsl()) {
                    ServerSSLOptions sslOptions = this.options.getSslOptions();
                    this.configure(sslOptions);
                    this.sslContextProvider = this.sslContextManager.resolveSslContextProvider(sslOptions, null, sslOptions.getClientAuth(), sslOptions.getApplicationLayerProtocols(), this.listenContext).onComplete(ar -> {
                        if (ar.succeeded()) {
                            this.bind(hostOrPath, context, bindAddress, localAddress, shared, promise, sharedNetServers, id);
                        } else {
                            promise.fail(ar.cause());
                        }
                    });
                } else {
                    this.bind(hostOrPath, context, bindAddress, localAddress, shared, promise, sharedNetServers, id);
                }
                this.bindFuture.onFailure(err -> {
                    if (shared) {
                        Map map = sharedNetServers;
                        synchronized (map) {
                            sharedNetServers.remove(id);
                        }
                    }
                    this.listening = false;
                });
                return this.bindFuture;
            }
            this.actualServer = main;
            this.metrics = main.metrics;
            this.trafficShapingHandler = main.trafficShapingHandler;
            this.initializer = new NetSocketInitializer(context, this.handler, this.exceptionHandler, this.trafficShapingHandler);
            this.worker = ch -> {
                group.add(ch);
                Future<SslContextProvider> scp = this.actualServer.sslContextProvider;
                this.initializer.accept((Channel)ch, scp != null ? scp.result() : null, this.sslContextManager, this.options.getSslOptions());
            };
            this.actualServer.channelBalancer.addWorker(this.eventLoop, this.worker);
            this.listenContext.addCloseHook(this);
            main.bindFuture.onComplete(promise);
            return promise.future();
        }
    }

    private void bind(String hostOrPath, ContextInternal context, SocketAddress bindAddress, SocketAddress localAddress, boolean shared, Promise<Channel> promise, Map<ServerID, NetServerInternal> sharedNetServers, ServerID id) {
        this.channelBalancer.addWorker(this.eventLoop, this.worker);
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(this.vertx.acceptorEventLoopGroup(), (EventLoopGroup)this.channelBalancer.workers());
        bootstrap.childHandler((ChannelHandler)this.channelBalancer);
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)VertxByteBufAllocator.POOLED_ALLOCATOR);
        this.applyConnectionOptions(localAddress.isDomainSocket(), bootstrap);
        io.netty.util.concurrent.Future<Channel> bindFuture = NetServerImpl.resolveAndBind(context, bindAddress, bootstrap);
        bindFuture.addListener(res -> {
            if (res.isSuccess()) {
                Channel ch = (Channel)res.getNow();
                log.trace((Object)("Net server listening on " + hostOrPath + ":" + String.valueOf(ch.localAddress())));
                if (shared) {
                    ch.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                        Map map = sharedNetServers;
                        synchronized (map) {
                            sharedNetServers.remove(id);
                        }
                    }));
                }
                if (bindAddress.isInetSocket()) {
                    this.actualPort = ((InetSocketAddress)ch.localAddress()).getPort();
                }
                this.metrics = this.createMetrics(localAddress);
                promise.complete(ch);
            } else {
                promise.fail(res.cause());
            }
        });
    }

    public boolean isListening() {
        return this.listening;
    }

    private TCPMetrics<?> createMetrics(SocketAddress localAddress) {
        VertxMetrics metrics = this.vertx.metrics();
        if (metrics != null) {
            if (this.options instanceof HttpServerOptions) {
                return metrics.createHttpServerMetrics((HttpServerOptions)this.options, localAddress);
            }
            return metrics.createNetServerMetrics(this.options, localAddress);
        }
        return null;
    }

    private void applyConnectionOptions(boolean domainSocket, ServerBootstrap bootstrap) {
        this.vertx.transport().configure(this.options, domainSocket, bootstrap);
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public synchronized TCPMetrics<?> getMetrics() {
        return this.actualServer != null ? this.actualServer.metrics : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown(Completable<Void> completion) {
        boolean hasHandlers;
        Map<ServerID, NetServerInternal> servers;
        if (!this.listening) {
            completion.succeed();
            return;
        }
        if (this.closeEvent == null) {
            this.closeEvent = new ShutdownEvent(0L, TimeUnit.SECONDS);
        }
        this.graceFuture = this.channelGroup.newCloseFuture();
        this.listenContext.removeCloseHook(this);
        Map<ServerID, NetServerInternal> map = servers = this.vertx.sharedTcpServers();
        synchronized (map) {
            ServerChannelLoadBalancer balancer = this.actualServer.channelBalancer;
            balancer.removeWorker(this.eventLoop, this.worker);
            hasHandlers = balancer.hasHandlers();
        }
        if (hasHandlers) {
            this.broadcastShutdownEvent(completion);
        } else {
            Promise<Void> p2 = Promise.promise();
            this.actualServer.actualClose(p2);
            p2.future().onComplete(ar -> this.broadcastShutdownEvent(completion));
        }
    }

    private void broadcastShutdownEvent(Completable<Void> completion) {
        for (Channel ch : this.channelGroup) {
            ch.pipeline().fireUserEventTriggered((Object)this.closeEvent);
        }
        completion.succeed();
    }

    private void doGrace(Completable<Void> completion) {
        if (!this.listening) {
            completion.succeed();
            return;
        }
        if (this.closeEvent.timeout() > 0L) {
            long timerID = this.vertx.setTimer(this.closeEvent.timeUnit().toMillis(this.closeEvent.timeout()), v -> completion.succeed());
            this.graceFuture.addListener(future -> {
                if (this.vertx.cancelTimer(timerID)) {
                    completion.succeed();
                }
            });
        } else {
            completion.succeed();
        }
    }

    private void doClose(Completable<Void> completion) {
        if (!this.listening) {
            completion.succeed();
            return;
        }
        this.listening = false;
        ChannelGroupFuture f = this.channelGroup.close();
        completion.succeed();
    }

    private void actualClose(Promise<Void> done) {
        this.bindFuture.onComplete(ar -> {
            if (ar.succeeded()) {
                Channel channel = (Channel)ar.result();
                ChannelFuture a = channel.close();
                if (this.metrics != null) {
                    a.addListener(cg -> this.metrics.close());
                }
                a.addListener((GenericFutureListener)((PromiseInternal)done));
            } else {
                done.complete();
            }
        });
    }

    public static io.netty.util.concurrent.Future<Channel> resolveAndBind(ContextInternal context, SocketAddress socketAddress, ServerBootstrap bootstrap) {
        VertxInternal vertx = context.owner();
        io.netty.util.concurrent.Promise promise = vertx.acceptorEventLoopGroup().next().newPromise();
        try {
            bootstrap.channelFactory(vertx.transport().serverChannelFactory(socketAddress.isDomainSocket()));
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            return promise;
        }
        if (socketAddress.isDomainSocket()) {
            java.net.SocketAddress converted = vertx.transport().convert(socketAddress);
            ChannelFuture future2 = bootstrap.bind(converted);
            future2.addListener(f -> {
                if (f.isSuccess()) {
                    promise.setSuccess((Object)future2.channel());
                } else {
                    promise.setFailure(f.cause());
                }
            });
        } else {
            SocketAddressImpl impl = (SocketAddressImpl)socketAddress;
            if (impl.ipAddress() != null) {
                NetServerImpl.bind(bootstrap, impl.ipAddress(), socketAddress.port(), (io.netty.util.concurrent.Promise<Channel>)promise);
            } else {
                NameResolver resolver = vertx.nameResolver();
                io.netty.util.concurrent.Future<InetSocketAddress> fut = resolver.resolve(context.nettyEventLoop(), socketAddress.host());
                fut.addListener(future -> {
                    if (future.isSuccess()) {
                        NetServerImpl.bind(bootstrap, ((InetSocketAddress)future.getNow()).getAddress(), socketAddress.port(), (io.netty.util.concurrent.Promise<Channel>)promise);
                    } else {
                        promise.setFailure(future.cause());
                    }
                });
            }
        }
        return promise;
    }

    private static void bind(ServerBootstrap bootstrap, InetAddress address, int port, io.netty.util.concurrent.Promise<Channel> promise) {
        InetSocketAddress t = new InetSocketAddress(address, port);
        ChannelFuture future = bootstrap.bind((java.net.SocketAddress)t);
        future.addListener(f -> {
            if (f.isSuccess()) {
                promise.setSuccess((Object)future.channel());
            } else {
                promise.setFailure(f.cause());
            }
        });
    }

    private class NetSocketInitializer {
        private final ContextInternal context;
        private final Handler<NetSocket> connectionHandler;
        private final Handler<Throwable> exceptionHandler;
        private final GlobalTrafficShapingHandler trafficShapingHandler;

        NetSocketInitializer(ContextInternal context, Handler<NetSocket> connectionHandler, Handler<Throwable> exceptionHandler, GlobalTrafficShapingHandler trafficShapingHandler) {
            this.context = context;
            this.connectionHandler = connectionHandler;
            this.exceptionHandler = exceptionHandler;
            this.trafficShapingHandler = trafficShapingHandler;
        }

        protected synchronized boolean accept() {
            return true;
        }

        public void accept(Channel ch, SslContextProvider sslChannelProvider, SslContextManager sslContextManager, ServerSSLOptions sslOptions) {
            if (!this.accept()) {
                ch.close();
                return;
            }
            if (HAProxyMessageCompletionHandler.canUseProxyProtocol(NetServerImpl.this.options.isUseProxyProtocol())) {
                IdleStateHandler idle;
                io.netty.util.concurrent.Promise p = ch.eventLoop().newPromise();
                ch.pipeline().addLast(new ChannelHandler[]{new HAProxyMessageDecoder()});
                if (NetServerImpl.this.options.getProxyProtocolTimeout() > 0L) {
                    idle = new IdleStateHandler(0L, 0L, NetServerImpl.this.options.getProxyProtocolTimeout(), NetServerImpl.this.options.getProxyProtocolTimeoutUnit());
                    ch.pipeline().addLast("idle", (ChannelHandler)idle);
                } else {
                    idle = null;
                }
                ch.pipeline().addLast(new ChannelHandler[]{new HAProxyMessageCompletionHandler((io.netty.util.concurrent.Promise<Channel>)p)});
                p.addListener(future -> {
                    if (future.isSuccess()) {
                        if (idle != null) {
                            ch.pipeline().remove((ChannelHandler)idle);
                        }
                        this.configurePipeline((Channel)future.getNow(), sslChannelProvider, sslContextManager, sslOptions);
                    } else {
                        this.handleException(future.cause());
                    }
                });
            } else {
                this.configurePipeline(ch, sslChannelProvider, sslContextManager, sslOptions);
            }
        }

        private void configurePipeline(Channel ch, SslContextProvider sslContextProvider, SslContextManager sslContextManager, ServerSSLOptions sslOptions) {
            if (NetServerImpl.this.options.isSsl()) {
                SslChannelProvider sslChannelProvider = new SslChannelProvider(NetServerImpl.this.vertx, sslContextProvider, sslOptions.isSni());
                ch.pipeline().addLast("ssl", sslChannelProvider.createServerHandler(NetServerImpl.this.options.isUseAlpn(), NetServerImpl.this.options.getSslHandshakeTimeout(), NetServerImpl.this.options.getSslHandshakeTimeoutUnit(), HttpUtils.socketAddressToHostAndPort(ch.remoteAddress())));
                ChannelPromise p = ch.newPromise();
                ch.pipeline().addLast("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler((io.netty.util.concurrent.Promise<Void>)p));
                p.addListener(future -> {
                    if (future.isSuccess()) {
                        this.connected(ch, sslContextManager, sslOptions);
                    } else {
                        this.handleException(future.cause());
                    }
                });
            } else {
                this.connected(ch, sslContextManager, sslOptions);
            }
            if (this.trafficShapingHandler != null) {
                ch.pipeline().addFirst("globalTrafficShaping", (ChannelHandler)this.trafficShapingHandler);
            }
        }

        private void handleException(Throwable cause) {
            if (this.exceptionHandler != null) {
                this.context.emit(v -> this.exceptionHandler.handle(cause));
            }
        }

        private void connected(Channel ch, SslContextManager sslContextManager, SSLOptions sslOptions) {
            NetServerImpl.this.initChannel(ch.pipeline(), NetServerImpl.this.options.isSsl());
            Metrics metrics = NetServerImpl.this.getMetrics();
            VertxHandler<NetSocketImpl> handler = VertxHandler.create(arg_0 -> this.lambda$connected$3(sslContextManager, sslOptions, (TCPMetrics)metrics, arg_0));
            handler.removeHandler(NetSocketImpl::unregisterEventBusHandler);
            handler.addHandler(arg_0 -> this.lambda$connected$4((TCPMetrics)metrics, arg_0));
            ch.pipeline().addLast("handler", handler);
        }

        private /* synthetic */ void lambda$connected$4(TCPMetrics metrics, NetSocketImpl conn) {
            if (metrics != null) {
                conn.metric(metrics.connected(conn.remoteAddress(), conn.remoteName()));
            }
            conn.registerEventBusHandler();
            this.context.emit(conn, this.connectionHandler::handle);
        }

        private /* synthetic */ NetSocketImpl lambda$connected$3(SslContextManager sslContextManager, SSLOptions sslOptions, TCPMetrics metrics, ChannelHandlerContext ctx) {
            return new NetSocketImpl(this.context, ctx, sslContextManager, sslOptions, metrics, NetServerImpl.this.options.isRegisterWriteHandler());
        }
    }
}

