/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client.impl;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Timer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.client.impl.GrpcClientResponseImpl;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcErrorException;
import io.vertx.grpc.common.GrpcHeaderNames;
import io.vertx.grpc.common.GrpcMediaType;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcMessageImpl;
import io.vertx.grpc.common.impl.GrpcWriteStreamBase;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcClientRequestImpl<Req, Resp>
extends GrpcWriteStreamBase<GrpcClientRequestImpl<Req, Resp>, Req>
implements GrpcClientRequest<Req, Resp> {
    private final HttpClientRequest httpRequest;
    private final boolean scheduleDeadline;
    private ServiceName serviceName;
    private String methodName;
    private Future<GrpcClientResponse<Req, Resp>> response;
    private long timeout;
    private TimeUnit timeoutUnit;
    private String timeoutHeader;
    private Timer deadline;
    private boolean cancelled;
    private static final EnumMap<TimeUnit, Character> GRPC_TIMEOUT_UNIT_SUFFIXES = new EnumMap(TimeUnit.class);
    private static final TimeUnit[] GRPC_TIMEOUT_UNITS;

    public GrpcClientRequestImpl(HttpClientRequest httpRequest, long maxMessageSize, boolean scheduleDeadline, GrpcMessageEncoder<Req> messageEncoder, GrpcMessageDecoder<Resp> messageDecoder) {
        super(((PromiseInternal)httpRequest.response()).context(), "application/grpc", (WriteStream)httpRequest, messageEncoder);
        this.httpRequest = httpRequest;
        this.scheduleDeadline = scheduleDeadline;
        this.timeout = 0L;
        this.timeoutUnit = null;
        this.timeoutHeader = null;
        this.response = httpRequest.response().compose(httpResponse -> {
            String msg = null;
            String statusHeader = httpResponse.getHeader((CharSequence)GrpcHeaderNames.GRPC_STATUS);
            GrpcStatus status = statusHeader != null ? GrpcStatus.valueOf((int)Integer.parseInt(statusHeader)) : null;
            WireFormat format = null;
            if (status == null) {
                String contentType = httpResponse.getHeader(HttpHeaders.CONTENT_TYPE);
                if (contentType != null) {
                    format = GrpcMediaType.parseContentType((String)contentType, (String)"application/grpc");
                }
                msg = contentType == null ? "HTTP response missing content-type header" : "Invalid HTTP response content-type header";
            }
            if (format != null || status != null) {
                GrpcClientResponseImpl grpcResponse = new GrpcClientResponseImpl(this.context, this, format, status, (HttpClientResponse)httpResponse, messageDecoder);
                grpcResponse.init(this, maxMessageSize);
                grpcResponse.invalidMessageHandler(invalidMsg -> {
                    this.cancel();
                    grpcResponse.tryFail((Throwable)invalidMsg);
                });
                return Future.succeededFuture(grpcResponse);
            }
            httpResponse.request().reset(GrpcError.CANCELLED.http2ResetCode);
            return this.context().failedFuture(msg);
        }, err -> {
            if (err instanceof StreamResetException) {
                err = GrpcErrorException.create((StreamResetException)((StreamResetException)err));
            }
            return Future.failedFuture((Throwable)err);
        });
    }

    @Override
    public GrpcClientRequest<Req, Resp> serviceName(ServiceName serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public GrpcClientRequest<Req, Resp> fullMethodName(String fullMethodName) {
        if (this.isHeadersSent()) {
            throw new IllegalStateException("Request already sent");
        }
        int idx = fullMethodName.lastIndexOf(47);
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        this.serviceName = ServiceName.create((String)fullMethodName.substring(0, idx));
        this.methodName = fullMethodName.substring(idx + 1);
        return this;
    }

    @Override
    public GrpcClientRequest<Req, Resp> methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    @Override
    public GrpcClientRequest<Req, Resp> timeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        if (this.isHeadersSent()) {
            throw new IllegalStateException("Timeout must be set before sending request headers");
        }
        String headerValue = GrpcClientRequestImpl.toTimeoutHeader(timeout, unit);
        if (headerValue == null) {
            throw new IllegalArgumentException("Not a valid gRPC timeout value (" + timeout + "," + String.valueOf((Object)unit) + ")");
        }
        this.timeout = timeout;
        this.timeoutUnit = unit;
        this.timeoutHeader = headerValue;
        return this;
    }

    @Override
    public Timer deadline() {
        return this.deadline;
    }

    @Override
    public GrpcClientRequest<Req, Resp> idleTimeout(long timeout) {
        this.httpRequest.idleTimeout(timeout);
        return this;
    }

    protected void setHeaders(String contentType, MultiMap headers, boolean isEnd) {
        ServiceName serviceName = this.serviceName;
        String methodName = this.methodName;
        if (serviceName == null) {
            throw new IllegalStateException();
        }
        if (methodName == null) {
            throw new IllegalStateException();
        }
        if (headers != null) {
            MultiMap requestHeaders = this.httpRequest.headers();
            for (Map.Entry header : headers) {
                requestHeaders.add((String)header.getKey(), (String)header.getValue());
            }
        }
        if (this.timeout > 0L) {
            this.httpRequest.putHeader((CharSequence)GrpcHeaderNames.GRPC_TIMEOUT, (CharSequence)this.timeoutHeader);
        }
        String uri = serviceName.pathOf(methodName);
        this.httpRequest.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
        if (this.encoding != null) {
            this.httpRequest.putHeader((CharSequence)GrpcHeaderNames.GRPC_ENCODING, (CharSequence)this.encoding);
        }
        this.httpRequest.putHeader((CharSequence)GrpcHeaderNames.GRPC_ACCEPT_ENCODING, (CharSequence)"gzip");
        this.httpRequest.putHeader((CharSequence)HttpHeaderNames.TE, (CharSequence)"trailers");
        this.httpRequest.setChunked(true);
        this.httpRequest.setURI(uri);
        if (this.scheduleDeadline && this.timeout > 0L) {
            Timer timer;
            this.deadline = timer = this.context.timer(this.timeout, this.timeoutUnit);
            timer.onSuccess(v -> this.cancel());
        }
    }

    protected void setTrailers(MultiMap trailers) {
    }

    protected Future<Void> sendMessage(Buffer message, boolean compressed) {
        return this.httpRequest.write((Object)GrpcMessageImpl.encode((Buffer)message, (boolean)compressed, (boolean)false));
    }

    protected Future<Void> sendEnd() {
        return this.httpRequest.end();
    }

    void cancelTimeout() {
        Timer timer = this.deadline;
        if (timer != null && timer.cancel()) {
            this.deadline = null;
        }
    }

    @Override
    public Future<GrpcClientResponse<Req, Resp>> response() {
        return this.response;
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.context.execute(() -> {
            boolean responseEnded;
            if (this.response.failed()) {
                return;
            }
            if (this.response.succeeded()) {
                GrpcClientResponse resp = (GrpcClientResponse)this.response.result();
                if (resp.end().failed()) {
                    return;
                }
                responseEnded = resp.end().succeeded();
            } else {
                responseEnded = false;
            }
            if (!this.isTrailersSent() || !responseEnded) {
                this.httpRequest.reset(GrpcError.CANCELLED.http2ResetCode).onSuccess(v -> this.handleError(GrpcError.CANCELLED));
            }
        });
    }

    @Override
    public HttpConnection connection() {
        return this.httpRequest.connection();
    }

    public static String toTimeoutHeader(long timeout, TimeUnit timeoutUnit) {
        for (TimeUnit grpcTimeoutUnit : GRPC_TIMEOUT_UNITS) {
            String res = GrpcClientRequestImpl.toTimeoutHeader(timeout, timeoutUnit, grpcTimeoutUnit);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private static String toTimeoutHeader(long timeout, TimeUnit srcUnit, TimeUnit grpcTimeoutUnit) {
        long v = grpcTimeoutUnit.convert(timeout, srcUnit);
        if (v < 100000000L) {
            return Long.toString(v) + String.valueOf(GRPC_TIMEOUT_UNIT_SUFFIXES.get((Object)grpcTimeoutUnit));
        }
        return null;
    }

    static {
        GRPC_TIMEOUT_UNIT_SUFFIXES.put(TimeUnit.NANOSECONDS, Character.valueOf('n'));
        GRPC_TIMEOUT_UNIT_SUFFIXES.put(TimeUnit.MICROSECONDS, Character.valueOf('u'));
        GRPC_TIMEOUT_UNIT_SUFFIXES.put(TimeUnit.MILLISECONDS, Character.valueOf('m'));
        GRPC_TIMEOUT_UNIT_SUFFIXES.put(TimeUnit.SECONDS, Character.valueOf('S'));
        GRPC_TIMEOUT_UNIT_SUFFIXES.put(TimeUnit.MINUTES, Character.valueOf('M'));
        GRPC_TIMEOUT_UNIT_SUFFIXES.put(TimeUnit.HOURS, Character.valueOf('H'));
        GRPC_TIMEOUT_UNITS = new TimeUnit[]{TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS};
    }
}

