/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import io.netty.util.AsciiString;
import io.vertx.core.http.HttpHeaders;
import io.vertx.grpc.common.WireFormat;

public final class GrpcMediaType {
    public static final CharSequence GRPC = HttpHeaders.createOptimized((String)"application/grpc");
    public static final CharSequence GRPC_PROTO = HttpHeaders.createOptimized((String)"application/grpc+proto");
    public static final CharSequence GRPC_WEB = HttpHeaders.createOptimized((String)"application/grpc-web");
    public static final CharSequence GRPC_WEB_PROTO = HttpHeaders.createOptimized((String)"application/grpc-web+proto");
    public static final CharSequence GRPC_WEB_TEXT = HttpHeaders.createOptimized((String)"application/grpc-web-text");
    public static final CharSequence GRPC_WEB_TEXT_PROTO = HttpHeaders.createOptimized((String)"application/grpc-web-text+proto");

    public static boolean isGrpcWeb(CharSequence mediaType) {
        return AsciiString.regionMatches((CharSequence)GRPC_WEB, (boolean)true, (int)0, (CharSequence)mediaType, (int)0, (int)GRPC_WEB.length());
    }

    public static boolean isGrpcWebText(CharSequence mediaType) {
        return AsciiString.regionMatches((CharSequence)GRPC_WEB_TEXT, (boolean)true, (int)0, (CharSequence)mediaType, (int)0, (int)GRPC_WEB_TEXT.length());
    }

    public static WireFormat parseContentType(String contentType, String mediaType) {
        if (contentType.startsWith(mediaType)) {
            WireFormat format;
            String s = contentType.substring(mediaType.length());
            if (s.isEmpty()) {
                format = WireFormat.PROTOBUF;
            } else {
                switch (s) {
                    case "+json": {
                        format = WireFormat.JSON;
                        break;
                    }
                    case "+proto": {
                        format = WireFormat.PROTOBUF;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            return format;
        }
        return null;
    }

    private GrpcMediaType() {
    }
}

