/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.util.JsonFormat;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.WireFormat;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;

public interface GrpcMessageDecoder<T> {
    public static final GrpcMessageDecoder<Buffer> IDENTITY = new GrpcMessageDecoder<Buffer>(){

        @Override
        public Buffer decode(GrpcMessage msg) throws CodecException {
            return msg.payload();
        }

        @Override
        public boolean accepts(WireFormat format) {
            return true;
        }
    };
    public static final GrpcMessageDecoder<JsonObject> JSON_OBJECT = new GrpcMessageDecoder<JsonObject>(){

        @Override
        public JsonObject decode(GrpcMessage msg) throws CodecException {
            Object val = JSON_VALUE.decode(msg);
            if (val instanceof JsonObject) {
                return (JsonObject)val;
            }
            throw new CodecException("Was expecting an instance of JsonObject instead of " + val.getClass().getName());
        }

        @Override
        public boolean accepts(WireFormat format) {
            return format == WireFormat.JSON;
        }
    };
    public static final GrpcMessageDecoder<Object> JSON_VALUE = new GrpcMessageDecoder<Object>(){

        @Override
        public Object decode(GrpcMessage msg) throws CodecException {
            if (!WireFormat.JSON.equals((Object)msg.format())) {
                throw new CodecException("Was expecting a json message");
            }
            try {
                return Json.decodeValue((Buffer)msg.payload());
            }
            catch (DecodeException e) {
                throw new CodecException(e);
            }
        }

        @Override
        public boolean accepts(WireFormat format) {
            return format == WireFormat.JSON;
        }
    };

    public static <T> GrpcMessageDecoder<T> decoder(MessageOrBuilder messageOrBuilder) {
        final Message dit = messageOrBuilder.getDefaultInstanceForType();
        final Parser parser = dit.getParserForType();
        return new GrpcMessageDecoder<T>(){

            @Override
            public T decode(GrpcMessage msg) throws CodecException {
                switch (msg.format()) {
                    case PROTOBUF: {
                        try {
                            return parser.parseFrom(msg.payload().getBytes());
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw new CodecException(e);
                        }
                    }
                    case JSON: {
                        try {
                            Message.Builder builder = dit.toBuilder();
                            JsonFormat.parser().merge(msg.payload().toString(StandardCharsets.UTF_8), builder);
                            return builder.build();
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw new CodecException(e);
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid wire format: ");
            }

            @Override
            public boolean accepts(WireFormat format) {
                return true;
            }
        };
    }

    public static <T> GrpcMessageDecoder<T> json(final Supplier<Message.Builder> builder) {
        return new GrpcMessageDecoder<T>(){

            @Override
            public T decode(GrpcMessage msg) throws CodecException {
                try {
                    Message.Builder builderInstance = (Message.Builder)builder.get();
                    JsonFormat.parser().merge(msg.payload().toString(StandardCharsets.UTF_8), builderInstance);
                    return builderInstance.build();
                }
                catch (InvalidProtocolBufferException e) {
                    throw new CodecException(e);
                }
            }

            @Override
            public boolean accepts(WireFormat format) {
                return format == WireFormat.JSON;
            }
        };
    }

    public static <T> GrpcMessageDecoder<T> json(final Class<T> clazz) {
        return new GrpcMessageDecoder<T>(){

            @Override
            public T decode(GrpcMessage msg) throws CodecException {
                if (!WireFormat.JSON.equals((Object)msg.format())) {
                    throw new CodecException("Was expecting a json message");
                }
                try {
                    return Json.decodeValue((Buffer)msg.payload(), (Class)clazz);
                }
                catch (DecodeException e) {
                    throw new CodecException(e);
                }
            }

            @Override
            public boolean accepts(WireFormat format) {
                return format == WireFormat.JSON;
            }
        };
    }

    public T decode(GrpcMessage var1) throws CodecException;

    public boolean accepts(WireFormat var1);
}

