/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.WireFormat;
import java.util.Objects;

public class GrpcMessageImpl
implements GrpcMessage {
    private final String encoding;
    private final WireFormat format;
    private final Buffer payload;

    public GrpcMessageImpl(String encoding, WireFormat format, Buffer payload) {
        this.encoding = Objects.requireNonNull(encoding);
        this.format = Objects.requireNonNull(format);
        this.payload = Objects.requireNonNull(payload);
    }

    @Override
    public String encoding() {
        return this.encoding;
    }

    @Override
    public WireFormat format() {
        return this.format;
    }

    @Override
    public Buffer payload() {
        return this.payload;
    }

    public static Buffer encode(GrpcMessage message) {
        return GrpcMessageImpl.encode(message, false);
    }

    public static BufferInternal encode(GrpcMessage message, boolean trailer) {
        boolean compressed = !message.encoding().equals("identity");
        return GrpcMessageImpl.encode(message.payload(), compressed, trailer);
    }

    public static BufferInternal encode(Buffer payload, boolean compressed, boolean trailer) {
        int len = payload.length();
        BufferInternal encoded = BufferInternal.buffer((int)(5 + len));
        encoded.appendByte((byte)((trailer ? 128 : 0) | (compressed ? 1 : 0)));
        encoded.appendInt(len);
        encoded.appendBuffer(payload);
        return encoded;
    }
}

