/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.health.handler;

import com.google.protobuf.MessageOrBuilder;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.health.handler.GrpcHealthV1HandlerBase;
import io.vertx.grpc.health.v1.HealthCheckRequest;
import io.vertx.grpc.health.v1.HealthCheckResponse;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerRequest;
import java.util.Map;
import java.util.function.Supplier;

public class GrpcHealthCheckV1Handler
extends GrpcHealthV1HandlerBase
implements Handler<GrpcServerRequest<HealthCheckRequest, HealthCheckResponse>> {
    public static final ServiceMethod<HealthCheckRequest, HealthCheckResponse> SERVICE_METHOD = ServiceMethod.server((ServiceName)ServiceName.create((String)"grpc.health.v1.Health"), (String)"Check", (GrpcMessageEncoder)GrpcMessageEncoder.encoder(), (GrpcMessageDecoder)GrpcMessageDecoder.decoder((MessageOrBuilder)HealthCheckRequest.newBuilder()));

    public GrpcHealthCheckV1Handler(GrpcServer server, Map<String, Supplier<Future<Boolean>>> healthChecks) {
        super(server, healthChecks);
    }

    public void handle(GrpcServerRequest<HealthCheckRequest, HealthCheckResponse> request) {
        request.handler(check -> this.checkStatus(check.getService()).compose(result -> {
            if (result == HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN) {
                return request.response().status(GrpcStatus.NOT_FOUND).end();
            }
            HealthCheckResponse.Builder builder = HealthCheckResponse.newBuilder();
            builder.setStatus((HealthCheckResponse.ServingStatus)((Object)((Object)result)));
            return request.response().end((Object)builder.build());
        }).onFailure(failure -> request.response().status(GrpcStatus.INTERNAL).end()));
    }
}

