/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.health.handler;

import com.google.protobuf.MessageOrBuilder;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.health.HealthServiceOptions;
import io.vertx.grpc.health.handler.GrpcHealthV1HandlerBase;
import io.vertx.grpc.health.v1.HealthCheckRequest;
import io.vertx.grpc.health.v1.HealthCheckResponse;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.GrpcServerResponse;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrpcHealthWatchV1Handler
extends GrpcHealthV1HandlerBase
implements Handler<GrpcServerRequest<HealthCheckRequest, HealthCheckResponse>>,
Closeable {
    private static final Logger logger = Logger.getLogger(GrpcHealthWatchV1Handler.class.getName());
    public static final ServiceMethod<HealthCheckRequest, HealthCheckResponse> SERVICE_METHOD = ServiceMethod.server((ServiceName)ServiceName.create((String)"grpc.health.v1.Health"), (String)"Watch", (GrpcMessageEncoder)GrpcMessageEncoder.encoder(), (GrpcMessageDecoder)GrpcMessageDecoder.decoder((MessageOrBuilder)HealthCheckRequest.newBuilder()));
    private final Vertx vertx;
    private final HealthServiceOptions options;
    private final Map<String, Map<GrpcServerResponse<HealthCheckRequest, HealthCheckResponse>, Boolean>> watchers = new ConcurrentHashMap<String, Map<GrpcServerResponse<HealthCheckRequest, HealthCheckResponse>, Boolean>>();
    private long timerId = -1L;

    public GrpcHealthWatchV1Handler(Vertx vertx, GrpcServer server, Map<String, Supplier<Future<Boolean>>> healthChecks) {
        this(vertx, server, healthChecks, new HealthServiceOptions());
    }

    public GrpcHealthWatchV1Handler(Vertx vertx, GrpcServer server, Map<String, Supplier<Future<Boolean>>> healthChecks, HealthServiceOptions options) {
        super(server, healthChecks);
        this.vertx = vertx;
        this.options = options;
        this.timerId = vertx.setPeriodic(options.getHealthCheckInterval().toMillis(), id -> this.checkHealthStatusChanges());
    }

    private void checkHealthStatusChanges() {
        for (String service : this.watchers.keySet()) {
            this.checkStatus(service).onSuccess(result -> {
                HealthCheckResponse.Builder builder = HealthCheckResponse.newBuilder();
                builder.setStatus((HealthCheckResponse.ServingStatus)((Object)result));
                HealthCheckResponse response = builder.build();
                Map<GrpcServerResponse<HealthCheckRequest, HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
                if (serviceWatchers != null) {
                    for (GrpcServerResponse<HealthCheckRequest, HealthCheckResponse> watcher : serviceWatchers.keySet()) {
                        watcher.write((Object)response);
                    }
                }
            }).onFailure(failure -> logger.log(Level.WARNING, "Failed to check health status for service: " + service, (Throwable)failure));
        }
    }

    public void handle(GrpcServerRequest<HealthCheckRequest, HealthCheckResponse> request) {
        request.handler(check -> {
            String service = check.getService();
            GrpcServerResponse response = request.response();
            this.checkStatus(service).onSuccess(result -> {
                HealthCheckResponse.Builder builder = HealthCheckResponse.newBuilder();
                builder.setStatus((HealthCheckResponse.ServingStatus)((Object)((Object)result)));
                response.write((Object)builder.build());
                this.watchers.computeIfAbsent(service, k -> new ConcurrentHashMap()).put(response, Boolean.TRUE);
                request.connection().closeHandler(v -> this.removeWatcher(service, (GrpcServerResponse<HealthCheckRequest, HealthCheckResponse>)response));
                request.exceptionHandler(e -> this.removeWatcher(service, (GrpcServerResponse<HealthCheckRequest, HealthCheckResponse>)response));
            }).onFailure(failure -> {
                HealthCheckResponse.Builder builder = HealthCheckResponse.newBuilder();
                builder.setStatus(HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN);
                response.write((Object)builder.build());
                this.watchers.computeIfAbsent(service, k -> new ConcurrentHashMap()).put(response, Boolean.TRUE);
                request.connection().closeHandler(v -> this.removeWatcher(service, (GrpcServerResponse<HealthCheckRequest, HealthCheckResponse>)response));
                request.exceptionHandler(e -> this.removeWatcher(service, (GrpcServerResponse<HealthCheckRequest, HealthCheckResponse>)response));
            });
        });
    }

    private void removeWatcher(String service, GrpcServerResponse<HealthCheckRequest, HealthCheckResponse> response) {
        Map<GrpcServerResponse<HealthCheckRequest, HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
        if (serviceWatchers != null) {
            serviceWatchers.remove(response);
            if (serviceWatchers.isEmpty()) {
                this.watchers.remove(service);
            }
        }
    }

    @Override
    public void close() {
        if (this.timerId != -1L) {
            this.vertx.cancelTimer(this.timerId);
            this.timerId = -1L;
        }
        this.watchers.clear();
    }
}

