/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

public enum GrpcTranscodingError {
    CANCELLED(1, 408, "Request timeout"),
    UNKNOWN(2, 500, "Internal Server Error"),
    INVALID_ARGUMENT(3, 400, "Invalid Argument"),
    DEADLINE_EXCEEDED(4, 504, "Deadline Exceeded"),
    NOT_FOUND(5, 404, "Not Found"),
    ALREADY_EXISTS(6, 409, "Already Exists"),
    PERMISSION_DENIED(7, 403, "Permission Denied"),
    RESOURCE_EXHAUSTED(8, 429, "Resource Exhausted"),
    FAILED_PRECONDITION(9, 400, "Failed Precondition"),
    ABORTED(10, 409, "Aborted"),
    OUT_OF_RANGE(11, 400, "Out of Range"),
    UNIMPLEMENTED(12, 501, "Unimplemented"),
    INTERNAL(13, 500, "Internal Server Error"),
    UNAVAILABLE(14, 503, "Service Unavailable"),
    DATA_LOSS(15, 500, "Data Loss"),
    UNAUTHENTICATED(16, 401, "Unauthenticated");

    private final int http2StatusCode;
    private final int httpStatusCode;
    private final String message;

    private GrpcTranscodingError(int http2StatusCode, int httpStatusCode, String message) {
        this.http2StatusCode = http2StatusCode;
        this.httpStatusCode = httpStatusCode;
        this.message = message;
    }

    public static GrpcTranscodingError fromHttp2Code(int code) {
        for (GrpcTranscodingError error : GrpcTranscodingError.values()) {
            if (error.http2StatusCode != code) continue;
            return error;
        }
        return UNKNOWN;
    }

    public int getHttp2StatusCode() {
        return this.http2StatusCode;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getMessage() {
        return this.message;
    }
}

