/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

import io.vertx.grpc.transcoding.MethodTranscodingOptions;
import io.vertx.grpc.transcoding.impl.PathMatcher;
import io.vertx.grpc.transcoding.impl.PathMatcherMethodData;
import io.vertx.grpc.transcoding.impl.PathMatcherNode;
import io.vertx.grpc.transcoding.impl.PathMatcherUtility;
import io.vertx.grpc.transcoding.impl.PercentEncoding;
import io.vertx.grpc.transcoding.impl.config.HttpTemplate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PathMatcherBuilder {
    private final PathMatcherNode root = new PathMatcherNode();
    private final Set<String> customVerbs = new HashSet<String>();
    private final List<PathMatcherMethodData> methods = new ArrayList<PathMatcherMethodData>();
    private PercentEncoding.UrlUnescapeSpec pathUnescapeSpec = PercentEncoding.UrlUnescapeSpec.ALL_CHARACTERS_EXCEPT_RESERVED;
    private boolean queryParamUnescapePlus = false;
    private boolean matchUnregisteredCustomVerb = false;
    private boolean failRegistrationOnDuplicate = true;

    public boolean register(MethodTranscodingOptions transcoding, Set<String> queryParameterNames, String method) {
        HttpTemplate ht = HttpTemplate.parse(transcoding.getPath());
        if (ht == null) {
            return false;
        }
        PathMatcherNode.PathInfo info = PathMatcherUtility.transformHttpTemplate(ht);
        PathMatcherMethodData data = new PathMatcherMethodData();
        data.setMethod(method);
        data.setVariables(ht.getVariables());
        data.setBodyFieldPath(transcoding.getBody());
        data.setSystemQueryParameterNames(queryParameterNames);
        if (!this.insertPathToNode(info, data, String.valueOf(transcoding.getHttpMethod()) + ht.getVerb(), this.root)) {
            return false;
        }
        this.methods.add(data);
        if (!ht.getVerb().isEmpty()) {
            this.customVerbs.add(ht.getVerb());
        }
        return true;
    }

    public boolean register(MethodTranscodingOptions transcodingOptions, String method) {
        return this.register(transcodingOptions, new HashSet<String>(), method);
    }

    private boolean insertPathToNode(PathMatcherNode.PathInfo path, Object data, String httpMethod, PathMatcherNode root) {
        return root.insertPath(path, httpMethod, data, true) || !this.failRegistrationOnDuplicate;
    }

    public PathMatcherNode root() {
        return this.root;
    }

    public Set<String> customVerbs() {
        return this.customVerbs;
    }

    public List<PathMatcherMethodData> methodData() {
        return this.methods;
    }

    public void setUrlUnescapeSpec(PercentEncoding.UrlUnescapeSpec pathUnescapeSpec) {
        this.pathUnescapeSpec = pathUnescapeSpec;
    }

    public PercentEncoding.UrlUnescapeSpec getUrlUnescapeSpec() {
        return this.pathUnescapeSpec;
    }

    public void setQueryParamUnescapePlus(boolean queryParamUnescapePlus) {
        this.queryParamUnescapePlus = queryParamUnescapePlus;
    }

    public boolean getQueryParamUnescapePlus() {
        return this.queryParamUnescapePlus;
    }

    public void setMatchUnregisteredCustomVerb(boolean matchUnregisteredCustomVerb) {
        this.matchUnregisteredCustomVerb = matchUnregisteredCustomVerb;
    }

    public boolean getMatchUnregisteredCustomVerb() {
        return this.matchUnregisteredCustomVerb;
    }

    public void setFailRegistrationOnDuplicate(boolean failRegistrationOnDuplicate) {
        this.failRegistrationOnDuplicate = failRegistrationOnDuplicate;
    }

    public boolean getFailRegistrationOnDuplicate() {
        return this.failRegistrationOnDuplicate;
    }

    public PathMatcher build() {
        return new PathMatcher(this);
    }
}

