/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.httpproxy.BodyTransformer;
import io.vertx.httpproxy.MediaType;
import io.vertx.httpproxy.impl.BodyTransformerImpl;
import java.util.function.Function;

@VertxGen
public interface BodyTransformers {
    public static final long DEFAULT_MAX_BUFFERED_SIZE = 262144L;

    @GenIgnore(value={"permitted-type"})
    public static BodyTransformer transform(MediaType consumes, MediaType produces, Function<Buffer, Buffer> transformer) {
        return BodyTransformers.transform(consumes, produces, 262144L, transformer);
    }

    @GenIgnore(value={"permitted-type"})
    public static BodyTransformer transform(MediaType consumes, MediaType produces, long maxBufferedBytes, Function<Buffer, Buffer> transformer) {
        return new BodyTransformerImpl(transformer, maxBufferedBytes, consumes, produces);
    }

    public static BodyTransformer jsonObject(long maxBufferedBytes, Function<JsonObject, JsonObject> transformer) {
        return BodyTransformerImpl.transformJsonObject(maxBufferedBytes, transformer);
    }

    public static BodyTransformer jsonObject(Function<JsonObject, JsonObject> transformer) {
        return BodyTransformers.jsonObject(262144L, transformer);
    }

    public static BodyTransformer jsonArray(long maxBufferedBytes, Function<JsonArray, JsonArray> transformer) {
        return BodyTransformerImpl.transformJsonArray(maxBufferedBytes, transformer);
    }

    public static BodyTransformer jsonArray(Function<JsonArray, JsonArray> transformer) {
        return BodyTransformers.jsonArray(262144L, transformer);
    }

    public static BodyTransformer jsonValue(long maxBufferedBytes, Function<Object, Object> transformer) {
        return BodyTransformerImpl.transformJsonValue(maxBufferedBytes, transformer);
    }

    public static BodyTransformer jsonValue(Function<Object, Object> transformer) {
        return BodyTransformers.jsonValue(262144L, transformer);
    }

    public static BodyTransformer text(long maxBufferedBytes, Function<String, String> transformer, String encoding) {
        return BodyTransformerImpl.transformText(maxBufferedBytes, encoding, transformer);
    }

    public static BodyTransformer text(Function<String, String> transformer, String encoding) {
        return BodyTransformers.text(262144L, transformer, encoding);
    }

    public static BodyTransformer discard() {
        return BodyTransformerImpl.discard();
    }
}

