/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.httpproxy.impl.MediaTypeImpl;
import java.util.List;

@DataObject
public interface MediaType {
    public static final MediaType ANY = MediaType.parse("*/*");
    public static final MediaType APPLICATION = MediaType.parse("application/*");
    public static final MediaType APPLICATION_OCTET_STREAM = MediaType.parse("application/octet-stream");
    public static final MediaType APPLICATION_JSON = MediaType.parse("application/json");
    public static final MediaType TEXT = MediaType.parse("text/*");
    public static final MediaType TEXT_PLAIN = MediaType.parse("text/plain");

    public static List<MediaType> parseAcceptHeader(String header) throws IllegalArgumentException {
        return MediaTypeImpl.parseCommaSeparatedList(header, 0);
    }

    public static MediaType parse(String s) {
        return MediaTypeImpl.parseMediaType(s, 0);
    }

    public String type();

    public String subType();

    public boolean accepts(MediaType var1);

    public String parameter(String var1);
}

