/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.cache;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.httpproxy.cache.CacheOptionsConverter;
import java.util.Map;
import java.util.Objects;

@DataObject
@JsonGen(publicConverter=false)
public class CacheOptions {
    public static final int DEFAULT_MAX_SIZE = 1000;
    public static final String DEFAULT_NAME = "__vertx.DEFAULT";
    public static final boolean DEFAULT_SHARED = false;
    private int maxSize = 1000;
    private String name = "__vertx.DEFAULT";
    private boolean shared = false;

    public CacheOptions() {
    }

    public CacheOptions(CacheOptions other) {
        this.maxSize = other.getMaxSize();
        this.name = other.getName();
        this.shared = other.isShared();
    }

    public CacheOptions(JsonObject json) {
        CacheOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public CacheOptions setMaxSize(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("Max size must be > 0");
        }
        this.maxSize = maxSize;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CacheOptions setName(String name) {
        Objects.requireNonNull(name, "Client name cannot be null");
        this.name = name;
        return this;
    }

    public boolean isShared() {
        return this.shared;
    }

    public CacheOptions setShared(boolean shared) {
        this.shared = shared;
        return this;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CacheOptionsConverter.toJson(this, json);
        return json;
    }
}

