/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.httpproxy.Body;
import io.vertx.httpproxy.BodyTransformer;
import io.vertx.httpproxy.MediaType;
import io.vertx.httpproxy.impl.ProxyFailure;
import java.util.function.Function;

public class BodyTransformerImpl
implements BodyTransformer {
    private final Function<Buffer, Buffer> transformer;
    private final long maxBufferedBytes;
    private final MediaType consumes;
    private final MediaType produces;

    public BodyTransformerImpl(Function<Buffer, Buffer> transformer, long maxBufferedBytes, MediaType consumedMediaType, MediaType produces) {
        this.transformer = transformer;
        this.maxBufferedBytes = maxBufferedBytes;
        this.consumes = consumedMediaType;
        this.produces = produces;
    }

    @Override
    public Future<Body> transform(Body body) {
        Promise p = Promise.promise();
        BodyAccumulator accumulator = new BodyAccumulator(this.transformer, this.maxBufferedBytes, (Completable<Buffer>)((Completable)(b, err) -> {
            if (err == null) {
                p.complete((Object)Body.body(b, this.produces));
            } else {
                p.fail(err);
            }
        }));
        ReadStream<Buffer> stream = body.stream();
        stream.handler(accumulator::handleBuffer);
        stream.endHandler(accumulator::handleEnd);
        stream.resume();
        return p.future();
    }

    @Override
    public boolean consumes(MediaType mediaType) {
        return this.consumes == null || mediaType != null && this.consumes.accepts(mediaType);
    }

    @Override
    public MediaType produces(MediaType mediaType) {
        return this.produces;
    }

    public static BodyTransformerImpl transformJsonObject(long maxBufferedBytes, Function<JsonObject, JsonObject> transformer) {
        return new BodyTransformerImpl(buffer -> ((JsonObject)transformer.apply(buffer.toJsonObject())).toBuffer(), maxBufferedBytes, MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON);
    }

    public static BodyTransformerImpl transformJsonArray(long maxBufferedBytes, Function<JsonArray, JsonArray> transformer) {
        return new BodyTransformerImpl(buffer -> ((JsonArray)transformer.apply(buffer.toJsonArray())).toBuffer(), maxBufferedBytes, MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON);
    }

    public static BodyTransformerImpl transformJsonValue(long maxBufferedBytes, Function<Object, Object> transformer) {
        return new BodyTransformerImpl(buffer -> Json.encodeToBuffer(transformer.apply(Json.decodeValue((Buffer)buffer))), maxBufferedBytes, MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON);
    }

    public static BodyTransformerImpl transformText(long maxBufferedBytes, String encoding, Function<String, String> transformer) {
        return new BodyTransformerImpl(buffer -> Buffer.buffer((String)((String)transformer.apply(buffer.toString(encoding)))), maxBufferedBytes, MediaType.TEXT_PLAIN, MediaType.TEXT_PLAIN);
    }

    public static BodyTransformer discard() {
        return new BodyTransformer(){

            @Override
            public boolean consumes(MediaType mediaType) {
                return true;
            }

            @Override
            public MediaType produces(MediaType mediaType) {
                return null;
            }

            @Override
            public Future<Body> transform(Body body) {
                return Future.succeededFuture((Object)Body.body(Buffer.buffer(), null));
            }
        };
    }

    private static class BodyAccumulator {
        private final long maxBufferedBytes;
        private final Function<Buffer, Buffer> transformer;
        private final Completable<Buffer> completion;
        private Buffer accumulator = Buffer.buffer();

        BodyAccumulator(Function<Buffer, Buffer> transformer, long maxBufferedBytes, Completable<Buffer> completion) {
            this.transformer = transformer;
            this.maxBufferedBytes = maxBufferedBytes;
            this.completion = completion;
        }

        void handleBuffer(Buffer buffer) {
            if (this.accumulator != null) {
                this.accumulator.appendBuffer(buffer);
                if ((long)buffer.length() > this.maxBufferedBytes) {
                    this.accumulator = null;
                }
            }
        }

        void handleEnd(Void end) {
            if (this.accumulator != null) {
                Buffer body = this.transformBody(this.accumulator);
                this.accumulator = null;
                if (body != null) {
                    this.completion.succeed((Object)body);
                    return;
                }
            }
            this.completion.fail((Throwable)((Object)new ProxyFailure(500)));
        }

        private Buffer transformBody(Buffer body) {
            try {
                return this.transformer.apply(body);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

