/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.httpproxy.MediaType;
import io.vertx.httpproxy.impl.ParameterValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public class MediaTypeImpl
implements MediaType,
BiConsumer<String, ParameterValue> {
    private final String type;
    private final String subType;
    private Map<String, ParameterValue> parameters;
    private String string;
    private int pos;

    public static List<MediaType> parseCommaSeparatedList(String s, int pos) {
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        while (true) {
            MediaTypeImpl mediaType;
            if ((mediaType = MediaTypeImpl.parseMediaType(s, pos)) == null) {
                throw new IllegalArgumentException("Invalid value: " + s);
            }
            list.add(mediaType);
            pos = mediaType.pos;
            mediaType.pos = 0;
            pos = MediaTypeImpl.parseOWS(s, pos);
            if (pos == s.length() || s.charAt(pos) != ',') break;
            pos = MediaTypeImpl.parseOWS(s, pos + 1);
        }
        return list;
    }

    public static MediaTypeImpl parseMediaType(String s, int pos) {
        int idx2;
        int idx1 = MediaTypeImpl.parseToken(s, pos);
        if (idx1 > pos && idx1 < s.length() && s.charAt(idx1) == '/' && (idx2 = MediaTypeImpl.parseToken(s, idx1 + 1)) > idx1 + 1) {
            String type = s.substring(pos, idx1);
            String subType = s.substring(idx1 + 1, idx2);
            MediaTypeImpl mt = new MediaTypeImpl(type, subType);
            int idx3 = idx2;
            while ((idx3 = MediaTypeImpl.parseOWS(s, idx3)) < s.length() && s.charAt(idx3) == ';') {
                int idx4 = MediaTypeImpl.parseOWS(s, idx3 + 1);
                idx3 = MediaTypeImpl.parseParameter(s, idx4, mt);
            }
            mt.pos = idx3;
            return mt;
        }
        return null;
    }

    public static int parseParameter(String s, int pos) {
        return MediaTypeImpl.parseParameter(s, pos, (name, value) -> {});
    }

    private static int parseParameter(String s, int pos, BiConsumer<String, ParameterValue> handler) {
        int idx1 = MediaTypeImpl.parseToken(s, pos);
        if (idx1 > pos && idx1 < s.length() && s.charAt(idx1) == '=') {
            int idx2 = MediaTypeImpl.parseToken(s, idx1 + 1);
            if (idx2 > idx1 + 1) {
                handler.accept(s.substring(pos, idx1), new ParameterValue(s.substring(idx1 + 1, idx2), false));
                return idx2;
            }
            idx2 = MediaTypeImpl.parseQuotedString(s, idx1 + 1);
            if (idx2 > idx1 + 1) {
                handler.accept(s.substring(pos, idx1), new ParameterValue(s.substring(idx1 + 2, idx2 - 1), true));
                return idx2;
            }
        }
        return pos;
    }

    public static int parseQuotedString(String s, int pos) {
        if (pos < s.length() && MediaTypeImpl.isDQUOTE(s.charAt(pos))) {
            int idx = pos + 1;
            while (idx < s.length()) {
                char c = s.charAt(idx);
                if (MediaTypeImpl.isQdtext(c)) {
                    ++idx;
                    continue;
                }
                if (c != '\\' || idx + 1 >= s.length() || !((c = s.charAt(idx + 1)) == '\t' | c == ' ' | MediaTypeImpl.isVCHAR(c))) break;
                idx += 2;
            }
            if (idx < s.length() && MediaTypeImpl.isDQUOTE(s.charAt(idx))) {
                return idx + 1;
            }
        }
        return pos;
    }

    public static boolean isVCHAR(char c) {
        return c >= '!' && c <= '~';
    }

    public static boolean isQdtext(char c) {
        return c == '\t' | c == ' ' | c == '!' | (c >= '#' && c <= '[') | (c >= ']' && c <= '~') | MediaTypeImpl.isObsText(c);
    }

    public static boolean isObsText(char c) {
        return c >= '\u0080' && c <= '\u00ff';
    }

    public static boolean isDQUOTE(char c) {
        return c == '\"';
    }

    public static int parseToken(String s, int pos) {
        int len = s.length();
        while (pos < len && MediaTypeImpl.isTchar(s.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private static boolean isTchar(char c) {
        return MediaTypeImpl.isALPHA(c) | MediaTypeImpl.isDIGIT(c) | c == '!' | c == '#' | c == '$' | c == '%' | c == '&' | c == '\\' | c == '*' | c == '+' | c == '-' | c == '.' | c == '^' | c == '_' | c == '`' | c == '|' | c == '~';
    }

    private static boolean isALPHA(char ch) {
        return 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z';
    }

    private static boolean isDIGIT(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private static int parseOWS(String s, int pos) {
        int length = s.length();
        while (pos < length && MediaTypeImpl.isOWS(s.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private static boolean isOWS(char c) {
        return c == ' ' | c == '\t';
    }

    public MediaTypeImpl(String type, String subType) {
        if (type == null && subType != null) {
            throw new IllegalArgumentException();
        }
        this.type = "*".equals(type) ? null : type;
        this.subType = "*".equals(subType) ? null : subType;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String subType() {
        return this.subType;
    }

    @Override
    public boolean accepts(MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.type == null) {
            return true;
        }
        if (this.type.equals(other.type())) {
            if (this.subType == null) {
                return true;
            }
            return this.subType.equals(other.subType());
        }
        return false;
    }

    @Override
    public String parameter(String name) {
        ParameterValue value;
        return this.parameters == null ? null : ((value = this.parameters.get(name)) == null ? null : value.value);
    }

    @Override
    public void accept(String name, ParameterValue value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, ParameterValue>();
        }
        this.parameters.put(name, value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MediaTypeImpl) {
            MediaTypeImpl that = (MediaTypeImpl)obj;
            if (Objects.equals(this.type, that.type) && Objects.equals(this.subType, that.subType)) {
                if (this.parameters != null) {
                    if (that.parameters != null && this.parameters.keySet().equals(that.parameters.keySet())) {
                        for (String parameterName : this.parameters.keySet()) {
                            if (this.parameters.get((Object)parameterName).value.equals(that.parameters.get((Object)parameterName).value)) continue;
                            return false;
                        }
                        return true;
                    }
                } else {
                    return that.parameters == null;
                }
            }
        }
        return false;
    }

    public String toString() {
        String ret = this.string;
        if (ret == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.type == null ? "*" : this.type);
            sb.append('/');
            sb.append(this.subType == null ? "*" : this.subType);
            if (this.parameters != null) {
                for (Map.Entry<String, ParameterValue> parameter : this.parameters.entrySet()) {
                    sb.append(';').append(parameter.getKey()).append('=');
                    ParameterValue value = parameter.getValue();
                    if (value.quoted) {
                        sb.append('\"');
                        sb.append(value.value);
                        sb.append('\"');
                        continue;
                    }
                    sb.append(value.value);
                }
            }
            this.string = ret = sb.toString();
        }
        return ret;
    }
}

