/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl.interceptor;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.httpproxy.BodyTransformer;
import io.vertx.httpproxy.ProxyInterceptor;
import io.vertx.httpproxy.ProxyInterceptorBuilder;
import io.vertx.httpproxy.impl.interceptor.ProxyInterceptorImpl;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProxyInterceptorBuilderImpl
implements ProxyInterceptorBuilder {
    private final Stream.Builder<Handler<MultiMap>> queryUpdaters = Stream.builder();
    private final Stream.Builder<Function<String, String>> pathUpdaters = Stream.builder();
    private final Stream.Builder<Handler<MultiMap>> requestHeadersUpdaters = Stream.builder();
    private final Stream.Builder<Handler<MultiMap>> responseHeadersUpdaters = Stream.builder();
    private BodyTransformer modifyRequestBody;
    private BodyTransformer modifyResponseBody;

    @Override
    public ProxyInterceptor build() {
        return new ProxyInterceptorImpl(this.queryUpdaters.build().collect(Collectors.toUnmodifiableList()), this.pathUpdaters.build().collect(Collectors.toUnmodifiableList()), this.requestHeadersUpdaters.build().collect(Collectors.toUnmodifiableList()), this.responseHeadersUpdaters.build().collect(Collectors.toUnmodifiableList()), this.modifyRequestBody, this.modifyResponseBody);
    }

    @Override
    public ProxyInterceptorBuilder transformingQueryParams(Handler<MultiMap> updater) {
        if (updater != null) {
            this.queryUpdaters.add(updater);
        }
        return this;
    }

    @Override
    public ProxyInterceptorBuilder settingQueryParam(String name, String value) {
        if (name != null && value != null) {
            return this.transformingQueryParams((Handler<MultiMap>)((Handler)map -> map.set(name, value)));
        }
        return this;
    }

    @Override
    public ProxyInterceptorBuilder removingQueryParam(String name) {
        if (name != null) {
            return this.transformingQueryParams((Handler<MultiMap>)((Handler)map -> map.remove(name)));
        }
        return this;
    }

    @Override
    public ProxyInterceptorBuilder transformingPath(Function<String, String> mutator) {
        if (mutator != null) {
            this.pathUpdaters.add(mutator);
        }
        return this;
    }

    @Override
    public ProxyInterceptorBuilder addingPathPrefix(String prefix) {
        if (prefix != null) {
            return this.transformingPath(path -> prefix + path);
        }
        return this;
    }

    @Override
    public ProxyInterceptorBuilder removingPathPrefix(String prefix) {
        if (prefix != null) {
            return this.transformingPath(path -> path.startsWith(prefix) ? path.substring(prefix.length()) : path);
        }
        return this;
    }

    @Override
    public ProxyInterceptorBuilder transformingRequestHeaders(Handler<MultiMap> requestHeadersUpdater) {
        if (requestHeadersUpdater != null) {
            this.requestHeadersUpdaters.add(requestHeadersUpdater);
        }
        return this;
    }

    @Override
    public ProxyInterceptorBuilder transformingResponseHeaders(Handler<MultiMap> responseHeadersUpdater) {
        if (responseHeadersUpdater != null) {
            this.responseHeadersUpdaters.add(responseHeadersUpdater);
        }
        return this;
    }

    @Override
    public ProxyInterceptorBuilder filteringRequestHeaders(Set<CharSequence> forbiddenRequestHeaders) {
        if (forbiddenRequestHeaders != null) {
            return this.transformingRequestHeaders((Handler<MultiMap>)((Handler)headers -> {
                for (CharSequence cs : forbiddenRequestHeaders) {
                    headers.remove(cs);
                }
            }));
        }
        return this;
    }

    @Override
    public ProxyInterceptorBuilder filteringResponseHeaders(Set<CharSequence> forbiddenResponseHeaders) {
        if (forbiddenResponseHeaders != null) {
            return this.transformingResponseHeaders((Handler<MultiMap>)((Handler)headers -> {
                for (CharSequence cs : forbiddenResponseHeaders) {
                    headers.remove(cs);
                }
            }));
        }
        return this;
    }

    @Override
    public ProxyInterceptorBuilder transformingRequestBody(BodyTransformer requestTransformer) {
        this.modifyRequestBody = requestTransformer;
        return this;
    }

    @Override
    public ProxyInterceptorBuilder transformingResponseBody(BodyTransformer responseTransformer) {
        this.modifyResponseBody = responseTransformer;
        return this;
    }
}

