/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl.interceptor;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpHeaders;
import io.vertx.httpproxy.Body;
import io.vertx.httpproxy.BodyTransformer;
import io.vertx.httpproxy.MediaType;
import io.vertx.httpproxy.ProxyContext;
import io.vertx.httpproxy.ProxyInterceptor;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.impl.ProxyFailure;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

class ProxyInterceptorImpl
implements ProxyInterceptor {
    private final List<Handler<MultiMap>> queryUpdaters;
    private final List<Function<String, String>> pathUpdaters;
    private final List<Handler<MultiMap>> requestHeadersUpdaters;
    private final List<Handler<MultiMap>> responseHeadersUpdaters;
    private final BodyTransformer modifyRequestBody;
    private final BodyTransformer modifyResponseBody;

    ProxyInterceptorImpl(List<Handler<MultiMap>> queryUpdaters, List<Function<String, String>> pathUpdaters, List<Handler<MultiMap>> requestHeadersUpdaters, List<Handler<MultiMap>> responseHeadersUpdaters, BodyTransformer modifyRequestBody, BodyTransformer modifyResponseBody) {
        this.queryUpdaters = Objects.requireNonNull(queryUpdaters);
        this.pathUpdaters = Objects.requireNonNull(pathUpdaters);
        this.requestHeadersUpdaters = Objects.requireNonNull(requestHeadersUpdaters);
        this.responseHeadersUpdaters = Objects.requireNonNull(responseHeadersUpdaters);
        this.modifyRequestBody = modifyRequestBody;
        this.modifyResponseBody = modifyResponseBody;
    }

    private MediaType safeMT(String mt) {
        try {
            return mt == null ? null : MediaType.parse(mt);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Future<ProxyResponse> handleProxyRequest(ProxyContext context) {
        try {
            this.queryHandleProxyRequest(context);
            this.pathHandleProxyRequest(context);
            this.headersHandleProxyRequest(context);
        }
        catch (Exception e) {
            return Future.failedFuture((Throwable)((Object)new ProxyFailure(500, e)));
        }
        Body requestBody = context.request().getBody();
        if (this.modifyRequestBody != null && requestBody != null) {
            boolean transform;
            MediaType bodyMediaType = this.safeMT(requestBody.mediaType());
            try {
                transform = (bodyMediaType != null || !context.request().headers().contains(HttpHeaders.CONTENT_TYPE)) && this.modifyRequestBody.consumes(bodyMediaType);
            }
            catch (Exception e) {
                return Future.failedFuture((Throwable)((Object)new ProxyFailure(500, e)));
            }
            if (transform) {
                Promise ret = Promise.promise();
                Future<Body> fut = this.modifyRequestBody.transform(context.request().getBody());
                fut.onComplete(ar -> {
                    if (ar.succeeded()) {
                        ProxyRequest request = context.request();
                        request.setBody((Body)ar.result());
                        context.sendRequest().onComplete((Completable)ret);
                    } else {
                        ret.fail(ar.cause());
                    }
                });
                return ret.future();
            }
        }
        return context.sendRequest();
    }

    private MediaType resolveMediaType(String acceptHeader, MediaType mt) throws IllegalArgumentException {
        List<MediaType> acceptedMediaTypes = MediaType.parseAcceptHeader(acceptHeader);
        MediaType produced = this.modifyResponseBody.produces(mt);
        for (MediaType acceptedMediaType : acceptedMediaTypes) {
            if (!acceptedMediaType.accepts(produced)) continue;
            return produced;
        }
        return null;
    }

    @Override
    public Future<Void> handleProxyResponse(ProxyContext context) {
        try {
            this.headersHandleProxyResponse(context);
        }
        catch (Exception e) {
            return Future.failedFuture((Throwable)((Object)new ProxyFailure(500, e)));
        }
        Body responseBody = context.response().getBody();
        if (this.modifyResponseBody != null && responseBody != null) {
            boolean checkTransform;
            MediaType bodyMediaType = this.safeMT(responseBody.mediaType());
            try {
                checkTransform = (bodyMediaType != null || !context.response().headers().contains(HttpHeaders.CONTENT_TYPE)) && this.modifyResponseBody.consumes(bodyMediaType);
            }
            catch (Exception e) {
                return Future.failedFuture((Throwable)((Object)new ProxyFailure(500, e)));
            }
            if (checkTransform) {
                boolean transform;
                String acceptHeader = context.request().headers().get((CharSequence)HttpHeaderNames.ACCEPT);
                if (acceptHeader != null) {
                    transform = false;
                    MediaType resolved = null;
                    try {
                        resolved = this.resolveMediaType(acceptHeader, bodyMediaType);
                        transform = resolved != null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    MediaType mediaType = resolved;
                } else {
                    transform = true;
                    try {
                        MediaType mediaType = this.modifyResponseBody.produces(bodyMediaType);
                    }
                    catch (Exception e) {
                        return Future.failedFuture((Throwable)((Object)new ProxyFailure(500, e)));
                    }
                }
                if (transform) {
                    Promise ret = Promise.promise();
                    Future<Body> fut = this.modifyResponseBody.transform(responseBody);
                    fut.onComplete(ar -> {
                        ProxyResponse response = context.response();
                        if (ar.succeeded()) {
                            response.setBody((Body)ar.result());
                            context.sendResponse();
                        } else {
                            ret.fail(ar.cause());
                        }
                    });
                    return ret.future();
                }
            }
        }
        return context.sendResponse();
    }

    private void queryHandleProxyRequest(ProxyContext context) {
        String rawUri = context.request().getURI();
        MultiMap params = ProxyInterceptorImpl.queryParams(rawUri);
        String cleanedUri = ProxyInterceptorImpl.cleanedUri(rawUri);
        for (Handler<MultiMap> queryUpdater : this.queryUpdaters) {
            queryUpdater.handle((Object)params);
        }
        String newUri = ProxyInterceptorImpl.buildUri(cleanedUri, params);
        context.request().setURI(newUri);
    }

    private static MultiMap queryParams(String uri) {
        MultiMap queryParams = MultiMap.caseInsensitiveMultiMap();
        int idx = uri.indexOf(63);
        if (idx >= 0) {
            QueryStringDecoder dec = new QueryStringDecoder(uri);
            dec.parameters().forEach((arg_0, arg_1) -> ((MultiMap)queryParams).add(arg_0, arg_1));
        }
        return queryParams;
    }

    private static String cleanedUri(String uri) {
        int idx = uri.indexOf(63);
        if (idx >= 0) {
            uri = uri.substring(0, idx);
        }
        return uri;
    }

    private static String buildUri(String uri, MultiMap queryParams) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        QueryStringEncoder encoder = new QueryStringEncoder(decoder.rawPath());
        decoder.parameters().forEach((name, values) -> {
            for (String value : values) {
                encoder.addParam(name, value);
            }
        });
        queryParams.forEach(param -> encoder.addParam((String)param.getKey(), (String)param.getValue()));
        uri = encoder.toString();
        return uri;
    }

    private void pathHandleProxyRequest(ProxyContext context) {
        ProxyRequest proxyRequest = context.request();
        for (Function<String, String> pathUpdater : this.pathUpdaters) {
            proxyRequest.setURI(pathUpdater.apply(proxyRequest.getURI()));
        }
    }

    private void headersHandleProxyRequest(ProxyContext context) {
        ProxyRequest request = context.request();
        for (Handler<MultiMap> requestHeadersUpdater : this.requestHeadersUpdaters) {
            requestHeadersUpdater.handle((Object)request.headers());
        }
    }

    private void headersHandleProxyResponse(ProxyContext context) {
        ProxyResponse response = context.response();
        for (Handler<MultiMap> responseHeadersUpdater : this.responseHeadersUpdaters) {
            responseHeadersUpdater.handle((Object)response.headers());
        }
    }
}

