/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.spi.cache;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.httpproxy.impl.ParseUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;

public class Resource
implements ClusterSerializable {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private String absoluteUri;
    private int statusCode;
    private String statusMessage;
    private MultiMap headers;
    private long timestamp;
    private long maxAge;
    private Instant lastModified;
    private String etag;
    private Buffer content = Buffer.buffer();

    public Resource() {
    }

    public Resource(String absoluteUri, int statusCode, String statusMessage, MultiMap headers, long timestamp, long maxAge) {
        String lastModifiedHeader = headers.get(HttpHeaders.LAST_MODIFIED);
        this.absoluteUri = absoluteUri;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = headers;
        this.timestamp = timestamp;
        this.maxAge = maxAge;
        this.lastModified = lastModifiedHeader != null ? ParseUtils.parseHeaderDate(lastModifiedHeader) : null;
        this.etag = headers.get(HttpHeaders.ETAG);
    }

    public void writeToBuffer(Buffer buffer) {
        Resource.appendString(buffer, this.absoluteUri);
        Resource.appendInt(buffer, this.statusCode);
        Resource.appendString(buffer, this.statusMessage);
        Resource.appendMultiMap(buffer, this.headers);
        Resource.appendLong(buffer, this.timestamp);
        Resource.appendLong(buffer, this.maxAge);
        Resource.appendInstant(buffer, this.lastModified);
        Resource.appendString(buffer, this.etag);
        Resource.appendBuffer(buffer, this.content);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        Cursor cursor = new Cursor();
        cursor.i = pos;
        this.setAbsoluteUri(Resource.readString(buffer, cursor));
        this.setStatusCode(Resource.readInt(buffer, cursor));
        this.setStatusMessage(Resource.readString(buffer, cursor));
        this.setHeaders(Resource.readMultiMap(buffer, cursor));
        this.setTimestamp(Resource.readLong(buffer, cursor));
        this.setMaxAge(Resource.readLong(buffer, cursor));
        this.setLastModified(Resource.readInstant(buffer, cursor));
        this.setEtag(Resource.readString(buffer, cursor));
        this.setContent(Resource.readBuffer(buffer, cursor));
        return cursor.i;
    }

    private static void appendIsNull(Buffer buffer, Object object) {
        buffer.appendByte((byte)(object == null ? 1 : 0));
    }

    private static boolean readIsNull(Buffer buffer, Cursor cursor) {
        ++cursor.i;
        return buffer.getByte(cursor.i - 1) == 1;
    }

    private static void appendInt(Buffer buffer, int num) {
        buffer.appendInt(num);
    }

    private static int readInt(Buffer buffer, Cursor cursor) {
        cursor.i += 4;
        return buffer.getInt(cursor.i - 4);
    }

    private static void appendLong(Buffer buffer, long num) {
        buffer.appendLong(num);
    }

    private static long readLong(Buffer buffer, Cursor cursor) {
        cursor.i += 8;
        return buffer.getLong(cursor.i - 8);
    }

    private static void appendInstant(Buffer buffer, Instant instant) {
        Resource.appendIsNull(buffer, instant);
        if (instant != null) {
            Resource.appendLong(buffer, instant.toEpochMilli());
        }
    }

    private static Instant readInstant(Buffer buffer, Cursor cursor) {
        if (Resource.readIsNull(buffer, cursor)) {
            return null;
        }
        return Instant.ofEpochMilli(Resource.readLong(buffer, cursor));
    }

    private static void appendBuffer(Buffer buffer, Buffer toAppend) {
        Resource.appendIsNull(buffer, toAppend);
        if (toAppend == null) {
            return;
        }
        byte[] bytes = toAppend.getBytes();
        buffer.appendInt(bytes.length).appendBytes(bytes);
    }

    private static Buffer readBuffer(Buffer buffer, Cursor cursor) {
        if (Resource.readIsNull(buffer, cursor)) {
            return null;
        }
        int len = buffer.getInt(cursor.i);
        cursor.i += 4;
        byte[] bytes = buffer.getBytes(cursor.i, cursor.i + len);
        cursor.i += len;
        return Buffer.buffer((byte[])bytes);
    }

    private static void appendString(Buffer buffer, String string) {
        Resource.appendBuffer(buffer, string == null ? null : Buffer.buffer((byte[])string.getBytes(UTF_8)));
    }

    private static String readString(Buffer buffer, Cursor cursor) {
        Buffer result = Resource.readBuffer(buffer, cursor);
        if (result == null) {
            return null;
        }
        return result.toString(UTF_8);
    }

    private static void appendMultiMap(Buffer buffer, MultiMap multiMap) {
        Resource.appendIsNull(buffer, multiMap);
        if (multiMap == null) {
            return;
        }
        buffer.appendInt(multiMap.size());
        multiMap.forEach((key, value) -> {
            Resource.appendString(buffer, key);
            Resource.appendString(buffer, value);
        });
    }

    private static MultiMap readMultiMap(Buffer buffer, Cursor cursor) {
        if (Resource.readIsNull(buffer, cursor)) {
            return null;
        }
        MultiMap multiMap = MultiMap.caseInsensitiveMultiMap();
        int size = buffer.getInt(cursor.i);
        cursor.i += 4;
        for (int i = 0; i < size; ++i) {
            multiMap.add(Resource.readString(buffer, cursor), Resource.readString(buffer, cursor));
        }
        return multiMap;
    }

    public String getAbsoluteUri() {
        return this.absoluteUri;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public String getEtag() {
        return this.etag;
    }

    public Buffer getContent() {
        return this.content;
    }

    public void setAbsoluteUri(String absoluteUri) {
        this.absoluteUri = absoluteUri;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public void setHeaders(MultiMap headers) {
        this.headers = headers;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public void setLastModified(Instant lastModified) {
        this.lastModified = lastModified;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public void setContent(Buffer content) {
        this.content = content;
    }

    private static class Cursor {
        int i;

        private Cursor() {
        }
    }
}

