/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.impl.BooleanSchema;
import io.vertx.json.schema.impl.JsonObjectSchema;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Utils {

    static class Schemas {
        Schemas() {
        }

        public static JsonSchema wrap(JsonObject object, String key) {
            Object value = object.getValue(key);
            if (value == null) {
                return null;
            }
            if (value instanceof JsonSchema) {
                return (JsonSchema)value;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BooleanSchema.TRUE : BooleanSchema.FALSE;
            }
            if (value instanceof JsonObject) {
                JsonObjectSchema schema = new JsonObjectSchema((JsonObject)value);
                object.put(key, (Object)schema);
                return schema;
            }
            return null;
        }

        public static JsonSchema wrap(JsonArray array, int index) {
            Object value = array.getValue(index);
            if (value == null) {
                return null;
            }
            if (value instanceof JsonSchema) {
                return (JsonSchema)value;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BooleanSchema.TRUE : BooleanSchema.FALSE;
            }
            if (value instanceof JsonObject) {
                JsonObjectSchema schema = new JsonObjectSchema((JsonObject)value);
                array.set(index, (Object)schema);
                return schema;
            }
            return null;
        }
    }

    static class Objects {
        Objects() {
        }

        public static boolean equals(Object a, Object b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null) {
                return false;
            }
            if (b == null) {
                return false;
            }
            if (a instanceof Number && b instanceof Number) {
                return Numbers.equals((Number)a, (Number)b);
            }
            return a.equals(b);
        }

        public static boolean truthy(Object instance) {
            if (instance == null) {
                return false;
            }
            if (instance instanceof Boolean) {
                return (Boolean)instance;
            }
            if (instance instanceof String) {
                return ((String)instance).length() > 0;
            }
            if (instance instanceof Number) {
                return Numbers.ze((Number)instance);
            }
            return false;
        }

        public static boolean isObject(Object instance) {
            return instance instanceof JsonObject || instance instanceof JsonArray;
        }
    }

    public static class Pointers {
        private static final String genDelims = ":?#@";
        private static final String subDelims = "!$&'()*+,;=";
        private static final String unreserved = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._";
        private static final String okChars = ":?#@!$&'()*+,;=0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._";

        public static String encode(String p) {
            byte[] bytes;
            StringBuilder encoded = new StringBuilder(p.length());
            for (byte aByte : bytes = p.getBytes(StandardCharsets.UTF_8)) {
                if (okChars.indexOf(aByte) >= 0) {
                    encoded.append((char)aByte);
                    continue;
                }
                if (aByte == 126) {
                    encoded.append("~0");
                    continue;
                }
                if (aByte == 47) {
                    encoded.append("~1");
                    continue;
                }
                encoded.append('%').append(Integer.toHexString(Byte.toUnsignedInt(aByte)).toUpperCase(Locale.ROOT));
            }
            return encoded.toString();
        }

        public static String unescape(String p) {
            return p.replaceAll("~1", "/").replaceAll("~0", "~");
        }

        public static String escape(String p) {
            return p.replaceAll("~", "~0").replaceAll("/", "~1");
        }
    }

    static class JSON {
        JSON() {
        }

        public static Object jsonify(Object instance) {
            if (instance instanceof Map) {
                return new JsonObject((Map)instance);
            }
            if (instance instanceof List) {
                return new JsonArray((List)instance);
            }
            return instance;
        }

        public static String typeOf(Object instance) {
            if (instance == null) {
                return "null";
            }
            if (instance instanceof Boolean) {
                return "boolean";
            }
            if (instance instanceof Number) {
                return "number";
            }
            if (instance instanceof String) {
                return "string";
            }
            if (instance instanceof JsonObject) {
                return "object";
            }
            if (instance instanceof JsonArray) {
                return "array";
            }
            throw new IllegalArgumentException("Instances of " + instance.getClass() + " type are not supported");
        }

        public static boolean deepCompare(Object a, Object b) {
            String typeofa = JSON.typeOf(a);
            if (!typeofa.equals(JSON.typeOf(b))) {
                return false;
            }
            if (a instanceof JsonArray) {
                if (!(b instanceof JsonArray)) {
                    return false;
                }
                int length = ((JsonArray)a).size();
                if (length != ((JsonArray)b).size()) {
                    return false;
                }
                for (int i = 0; i < length; ++i) {
                    if (JSON.deepCompare(((JsonArray)a).getValue(i), ((JsonArray)b).getValue(i))) continue;
                    return false;
                }
                return true;
            }
            if ("object".equals(typeofa)) {
                if (a == null || b == null) {
                    return a == b;
                }
                Set aKeys = ((JsonObject)a).fieldNames();
                Set bKeys = ((JsonObject)b).fieldNames();
                int length = aKeys.size();
                if (length != bKeys.size()) {
                    return false;
                }
                for (String k : aKeys) {
                    if (JSON.deepCompare(((JsonObject)a).getValue(k), ((JsonObject)b).getValue(k))) continue;
                    return false;
                }
                return true;
            }
            return Objects.equals(a, b);
        }
    }

    static class Strings {
        Strings() {
        }

        public static boolean notEmpty(String string) {
            return string != null && string.length() > 0;
        }

        public static boolean empty(String string) {
            return string == null || string.length() == 0;
        }

        public static int ucs2length(String s) {
            int result = 0;
            int length = s.length();
            int index = 0;
            while (index < length) {
                char charCode;
                ++result;
                if ((charCode = s.charAt(index++)) < '\ud800' || charCode > '\udbff' || index >= length || ((charCode = s.charAt(index)) & 0xFC00) != 56320) continue;
                ++index;
            }
            return result;
        }
    }

    static class Numbers {
        Numbers() {
        }

        public static boolean isInteger(Object instance) {
            if (instance instanceof Number) {
                if (instance instanceof Byte || instance instanceof Short || instance instanceof Integer || instance instanceof Long || instance instanceof BigInteger) {
                    return true;
                }
                if (instance instanceof Float) {
                    return ((Float)instance).floatValue() % 1.0f == 0.0f;
                }
                if (instance instanceof Double) {
                    return (Double)instance % 1.0 == 0.0;
                }
                if (instance instanceof BigDecimal) {
                    return ((BigDecimal)instance).remainder(BigDecimal.ONE).equals(BigDecimal.ZERO);
                }
            }
            return false;
        }

        private static BigDecimal toBigDecimal(Number in) {
            if (in instanceof BigDecimal) {
                return (BigDecimal)in;
            }
            if (in instanceof BigInteger) {
                return new BigDecimal((BigInteger)in);
            }
            if (in instanceof Float) {
                return BigDecimal.valueOf(in.floatValue());
            }
            if (in instanceof Double) {
                return BigDecimal.valueOf(in.doubleValue());
            }
            return BigDecimal.valueOf(in.longValue());
        }

        public static boolean ze(Number instance) {
            if (instance instanceof BigDecimal || instance instanceof BigInteger) {
                return Numbers.toBigDecimal(instance).compareTo(BigDecimal.ZERO) == 0;
            }
            return instance.doubleValue() == 0.0;
        }

        public static boolean lt(Number instance, Object value) {
            if (value instanceof Number) {
                if (instance instanceof BigDecimal || value instanceof BigDecimal || instance instanceof BigInteger || value instanceof BigInteger) {
                    return Numbers.toBigDecimal(instance).compareTo(Numbers.toBigDecimal((Number)value)) < 0;
                }
                return instance.doubleValue() < ((Number)value).doubleValue();
            }
            return false;
        }

        public static boolean lte(Number instance, Object value) {
            if (value instanceof Number) {
                if (instance instanceof BigDecimal || value instanceof BigDecimal || instance instanceof BigInteger || value instanceof BigInteger) {
                    return Numbers.toBigDecimal(instance).compareTo(Numbers.toBigDecimal((Number)value)) <= 0;
                }
                return instance.doubleValue() <= ((Number)value).doubleValue();
            }
            return false;
        }

        public static boolean gt(Number instance, Object value) {
            if (value instanceof Number) {
                if (instance instanceof BigDecimal || value instanceof BigDecimal || instance instanceof BigInteger || value instanceof BigInteger) {
                    return Numbers.toBigDecimal(instance).compareTo(Numbers.toBigDecimal((Number)value)) > 0;
                }
                return instance.doubleValue() > ((Number)value).doubleValue();
            }
            return false;
        }

        public static boolean gte(Number instance, Object value) {
            if (value instanceof Number) {
                if (instance instanceof BigDecimal || value instanceof BigDecimal || instance instanceof BigInteger || value instanceof BigInteger) {
                    return Numbers.toBigDecimal(instance).compareTo(Numbers.toBigDecimal((Number)value)) >= 0;
                }
                return instance.doubleValue() >= ((Number)value).doubleValue();
            }
            return false;
        }

        public static double remainder(Number instance, Number value) {
            if (instance instanceof BigDecimal || value instanceof BigDecimal || instance instanceof BigInteger || value instanceof BigInteger) {
                return Numbers.toBigDecimal(instance).remainder(Numbers.toBigDecimal(value)).doubleValue();
            }
            if (instance instanceof Double || value instanceof Double || instance instanceof Float || value instanceof Float) {
                return instance.doubleValue() % value.doubleValue();
            }
            return (double)instance.longValue() % value.doubleValue();
        }

        public static boolean equals(Number a, Number b) {
            if (a == null || b == null) {
                return false;
            }
            if (Numbers.isInteger(a) && Numbers.isInteger(b)) {
                if (a instanceof BigInteger || b instanceof BigInteger) {
                    return Numbers.toBigDecimal(a).equals(Numbers.toBigDecimal(b));
                }
                return a.longValue() == b.longValue();
            }
            if (a instanceof BigDecimal || b instanceof BigDecimal) {
                return Numbers.toBigDecimal(a).equals(Numbers.toBigDecimal(b));
            }
            return a.doubleValue() == b.doubleValue();
        }
    }
}

