/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.core.file.FileSystem;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Draft;
import io.vertx.json.schema.JsonFormatValidator;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.SchemaRepository;
import io.vertx.json.schema.Validator;
import io.vertx.json.schema.impl.BooleanSchema;
import io.vertx.json.schema.impl.JsonRef;
import io.vertx.json.schema.impl.SchemaValidatorImpl;
import io.vertx.json.schema.impl.URL;
import io.vertx.json.schema.impl.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class SchemaRepositoryImpl
implements SchemaRepository {
    private static final List<String> IGNORE_KEYWORD = Arrays.asList("id", "$id", "$ref", "$schema", "$anchor", "$vocabulary", "$comment", "default", "enum", "const", "required", "type", "maximum", "minimum", "exclusiveMaximum", "exclusiveMinimum", "multipleOf", "maxLength", "minLength", "pattern", "format", "maxItems", "minItems", "uniqueItems", "maxProperties", "minProperties");
    private static final List<String> SCHEMA_ARRAY_KEYWORD = Arrays.asList("prefixItems", "items", "allOf", "anyOf", "oneOf");
    private static final List<String> SCHEMA_MAP_KEYWORD = Arrays.asList("$defs", "definitions", "properties", "patternProperties", "dependentSchemas");
    private static final List<String> SCHEMA_KEYWORD = Arrays.asList("additionalItems", "unevaluatedItems", "items", "contains", "additionalProperties", "unevaluatedProperties", "propertyNames", "not", "if", "then", "else");
    public static final List<String> DRAFT_4_META_FILES = Collections.singletonList("http://json-schema.org/draft-04/schema");
    public static final List<String> DRAFT_7_META_FILES = Collections.singletonList("http://json-schema.org/draft-07/schema");
    public static final List<String> DRAFT_201909_META_FILES = Arrays.asList("https://json-schema.org/draft/2019-09/schema", "https://json-schema.org/draft/2019-09/meta/core", "https://json-schema.org/draft/2019-09/meta/applicator", "https://json-schema.org/draft/2019-09/meta/validation", "https://json-schema.org/draft/2019-09/meta/meta-data", "https://json-schema.org/draft/2019-09/meta/format", "https://json-schema.org/draft/2019-09/meta/content");
    public static final List<String> DRAFT_202012_META_FILES = Arrays.asList("https://json-schema.org/draft/2020-12/schema", "https://json-schema.org/draft/2020-12/meta/core", "https://json-schema.org/draft/2020-12/meta/applicator", "https://json-schema.org/draft/2020-12/meta/validation", "https://json-schema.org/draft/2020-12/meta/meta-data", "https://json-schema.org/draft/2020-12/meta/format-annotation", "https://json-schema.org/draft/2020-12/meta/content", "https://json-schema.org/draft/2020-12/meta/unevaluated");
    private final Map<String, JsonSchema> lookup = new ConcurrentHashMap<String, JsonSchema>();
    private final JsonSchemaOptions options;
    private final URL baseUri;
    private final JsonFormatValidator formatValidator;

    public SchemaRepositoryImpl(JsonSchemaOptions options, JsonFormatValidator formatValidator) {
        Objects.requireNonNull(options, "'options' cannot be null");
        Objects.requireNonNull(options.getBaseUri(), "'options.baseUri' cannot be null");
        Objects.requireNonNull(formatValidator, "'formatValidator' cannot be null");
        this.options = options;
        this.formatValidator = formatValidator;
        this.baseUri = new URL(options.getBaseUri());
    }

    @Override
    public SchemaRepository dereference(JsonSchema schema) throws SchemaException {
        SchemaRepositoryImpl.dereference(this.lookup, schema, this.baseUri, "", true);
        return this;
    }

    @Override
    public SchemaRepository dereference(String uri, JsonSchema schema) throws SchemaException {
        SchemaRepositoryImpl.dereference(this.lookup, schema, new URL(uri, this.options.getBaseUri()), "", true);
        return this;
    }

    @Override
    public SchemaRepository preloadMetaSchema(FileSystem fs) {
        if (this.options.getDraft() == null) {
            throw new IllegalStateException("No draft version is defined in the options of the repository");
        }
        return this.preloadMetaSchema(fs, this.options.getDraft());
    }

    @Override
    public SchemaRepository preloadMetaSchema(FileSystem fs, Draft draft) {
        List<String> metaSchemaIds;
        switch (draft) {
            case DRAFT4: {
                metaSchemaIds = DRAFT_4_META_FILES;
                break;
            }
            case DRAFT7: {
                metaSchemaIds = DRAFT_7_META_FILES;
                break;
            }
            case DRAFT201909: {
                metaSchemaIds = DRAFT_201909_META_FILES;
                break;
            }
            case DRAFT202012: {
                metaSchemaIds = DRAFT_202012_META_FILES;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        for (String id : metaSchemaIds) {
            JsonSchema schema = JsonSchema.of(fs.readFileBlocking(id.substring(id.indexOf("://") + 3)).toJsonObject());
            this.dereference(schema.get("$id", schema.get("id", id)), schema);
        }
        return this;
    }

    @Override
    public Validator validator(JsonSchema schema) {
        Objects.requireNonNull(schema, "'schema' cannot be null");
        if (schema.containsKey("__absolute_uri__")) {
            String uri;
            URL url = new URL((String)schema.get("__absolute_uri__"), this.baseUri);
            if ("".equals(url.fragment())) {
                url.anchor("");
            }
            if (this.lookup.containsKey(uri = url.href())) {
                Objects.requireNonNull(uri, "'ref' cannot be null");
                return new SchemaValidatorImpl(this.lookup.get(uri), this.options, Collections.unmodifiableMap(this.lookup), false, this.formatValidator);
            }
        }
        return new SchemaValidatorImpl(schema, this.options, Collections.unmodifiableMap(this.lookup), false, this.formatValidator);
    }

    @Override
    public Validator validator(String ref) {
        String uri;
        Objects.requireNonNull(ref, "'ref' cannot be null");
        URL url = new URL(ref, this.baseUri);
        if ("".equals(url.fragment())) {
            url.anchor("");
        }
        if (this.lookup.containsKey(uri = url.href())) {
            return new SchemaValidatorImpl(this.lookup.get(uri), this.options, Collections.unmodifiableMap(this.lookup), false, this.formatValidator);
        }
        throw new IllegalArgumentException("Unknown $ref: " + ref);
    }

    @Override
    public Validator validator(JsonSchema schema, JsonSchemaOptions options, boolean dereference) {
        JsonSchemaOptions config = options.getBaseUri() == null ? new JsonSchemaOptions(options).setBaseUri(this.baseUri.href()) : options;
        return new SchemaValidatorImpl(schema, config, Collections.unmodifiableMap(this.lookup), dereference, this.formatValidator);
    }

    @Override
    public Validator validator(String ref, JsonSchemaOptions options) {
        JsonSchemaOptions config = options.getBaseUri() == null ? new JsonSchemaOptions(options).setBaseUri(this.baseUri.href()) : options;
        URL url = new URL(ref, this.baseUri);
        String uri = url.href();
        if ("".equals(url.fragment())) {
            url.anchor("");
        }
        if (this.lookup.containsKey(uri)) {
            Objects.requireNonNull(uri, "'ref' cannot be null");
            return new SchemaValidatorImpl(this.lookup.get(uri), config, Collections.unmodifiableMap(this.lookup), false, this.formatValidator);
        }
        throw new IllegalArgumentException("Unknown $ref: " + ref);
    }

    @Override
    public JsonObject resolve(JsonObject schema) {
        HashMap<String, JsonSchema> lookup = new HashMap<String, JsonSchema>(Collections.unmodifiableMap(this.lookup));
        return JsonRef.resolve(schema, lookup);
    }

    @Override
    public JsonSchema find(String pointer) {
        URL url = new URL(pointer, this.baseUri);
        return this.lookup.get(url.href());
    }

    static void dereference(Map<String, JsonSchema> lookup, JsonSchema schema, URL baseURI, String basePointer, boolean schemaRoot) {
        String schemaURI;
        URL url;
        if (schema == null) {
            return;
        }
        if (!(schema instanceof BooleanSchema)) {
            String id;
            String string = id = schemaRoot ? schema.get("$id", (String)schema.get("id")) : null;
            if (Utils.Objects.truthy(id)) {
                url = new URL(id, baseURI.href());
                if (url.fragment().length() > 1) {
                    assert (!lookup.containsKey(url.href()));
                    lookup.put(url.href(), schema);
                } else {
                    url.anchor("");
                    if ("".equals(basePointer)) {
                        baseURI = url;
                    } else {
                        SchemaRepositoryImpl.dereference(lookup, schema, baseURI, "", schemaRoot);
                    }
                }
            }
        }
        if (lookup.containsKey(schemaURI = baseURI.href() + (String)(Utils.Objects.truthy(basePointer) ? "#" + basePointer : ""))) {
            JsonSchema existing = lookup.get(schemaURI);
            if (existing.equals(schema)) {
                return;
            }
            throw new SchemaException(schema, "Duplicate schema URI \"" + schemaURI + "\".");
        }
        lookup.put(schemaURI, schema);
        if (schema instanceof BooleanSchema) {
            return;
        }
        if (!schema.containsKey("__absolute_uri__")) {
            schema.annotate("__absolute_uri__", schemaURI);
        }
        if (schema.containsKey("$ref") && !schema.containsKey("__absolute_ref__")) {
            url = new URL((String)schema.get("$ref"), baseURI.href());
            url.anchor(url.fragment());
            schema.annotate("__absolute_ref__", url.href());
        }
        if (schema.containsKey("$recursiveRef") && !schema.containsKey("__absolute_recursive_ref__")) {
            url = new URL((String)schema.get("$recursiveRef"), baseURI.href());
            url.anchor(url.fragment());
            schema.annotate("__absolute_recursive_ref__", url.href());
        }
        if (schema.containsKey("$dynamicAnchor")) {
            url = new URL("#" + (String)schema.get("$dynamicAnchor"), baseURI.href());
            if (lookup.containsKey(url.href())) {
                assert (!lookup.get(url.href()).equals(schema));
            } else {
                lookup.put(url.href(), schema);
            }
        }
        if (schema.containsKey("$anchor")) {
            url = new URL("#" + (String)schema.get("$anchor"), baseURI);
            if (lookup.containsKey(url.href())) {
                assert (!lookup.get(url.href()).equals(schema));
            } else {
                lookup.put(url.href(), schema);
            }
        }
        for (String key : schema.fieldNames()) {
            if (IGNORE_KEYWORD.contains(key)) continue;
            String keyBase = basePointer + "/" + Utils.Pointers.encode(key);
            Object subSchema = schema.get(key);
            if (subSchema instanceof JsonArray) {
                if (!SCHEMA_ARRAY_KEYWORD.contains(key)) continue;
                for (int i = 0; i < ((JsonArray)subSchema).size(); ++i) {
                    SchemaRepositoryImpl.dereference(lookup, Utils.Schemas.wrap((JsonArray)subSchema, i), baseURI, keyBase + "/" + i, false);
                }
                continue;
            }
            if (SCHEMA_MAP_KEYWORD.contains(key)) {
                for (String subKey : ((JsonObject)subSchema).fieldNames()) {
                    SchemaRepositoryImpl.dereference(lookup, Utils.Schemas.wrap((JsonObject)subSchema, subKey), baseURI, keyBase + "/" + Utils.Pointers.encode(subKey), true);
                }
                continue;
            }
            if (subSchema instanceof Boolean) {
                SchemaRepositoryImpl.dereference(lookup, JsonSchema.of((Boolean)subSchema), baseURI, keyBase, SCHEMA_KEYWORD.contains(key));
                continue;
            }
            if (!(subSchema instanceof JsonObject)) continue;
            SchemaRepositoryImpl.dereference(lookup, JsonSchema.of((JsonObject)subSchema), baseURI, keyBase, SCHEMA_KEYWORD.contains(key));
        }
    }
}

