/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.client.common.Node;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.acl.AclOperation;

public class ClusterDescriptionConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, ClusterDescription obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "nodes": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Node> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Node((JsonObject)item));
                        }
                    });
                    obj.setNodes(list);
                    break;
                }
                case "controller": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setController(new Node((JsonObject)member.getValue()));
                    break;
                }
                case "clusterId": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClusterId((String)member.getValue());
                    break;
                }
                case "authorizedOperations": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Node> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((Node)AclOperation.valueOf((String)((String)item)));
                        }
                    });
                    obj.setAuthorizedOperations((Set<AclOperation>)((Object)list));
                }
            }
        }
    }

    static void toJson(ClusterDescription obj, JsonObject json) {
        ClusterDescriptionConverter.toJson(obj, json.getMap());
    }

    static void toJson(ClusterDescription obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getNodes() != null) {
            array = new JsonArray();
            obj.getNodes().forEach(item -> array.add((Object)item.toJson()));
            json.put("nodes", array);
        }
        if (obj.getController() != null) {
            json.put("controller", obj.getController().toJson());
        }
        if (obj.getClusterId() != null) {
            json.put("clusterId", obj.getClusterId());
        }
        if (obj.getAuthorizedOperations() != null) {
            array = new JsonArray();
            obj.getAuthorizedOperations().forEach(item -> array.add((Object)item.name()));
            json.put("authorizedOperations", array);
        }
    }
}

