/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.admin.TopicDescription;
import io.vertx.kafka.client.common.TopicPartitionInfo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.acl.AclOperation;

public class TopicDescriptionConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, TopicDescription obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "internal": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setInternal((Boolean)member.getValue());
                    break;
                }
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setName((String)member.getValue());
                    break;
                }
                case "authorizedOperations": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<AclOperation> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(AclOperation.valueOf((String)((String)item)));
                        }
                    });
                    obj.setAuthorizedOperations(list);
                    break;
                }
                case "partitions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<AclOperation> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((AclOperation)new TopicPartitionInfo((JsonObject)item));
                        }
                    });
                    obj.setPartitions((List<TopicPartitionInfo>)((Object)list));
                }
            }
        }
    }

    static void toJson(TopicDescription obj, JsonObject json) {
        TopicDescriptionConverter.toJson(obj, json.getMap());
    }

    static void toJson(TopicDescription obj, Map<String, Object> json) {
        JsonArray array;
        json.put("internal", obj.isInternal());
        if (obj.getName() != null) {
            json.put("name", obj.getName());
        }
        if (obj.getAuthorizedOperations() != null) {
            array = new JsonArray();
            obj.getAuthorizedOperations().forEach(item -> array.add((Object)item.name()));
            json.put("authorizedOperations", array);
        }
        if (obj.getPartitions() != null) {
            array = new JsonArray();
            obj.getPartitions().forEach(item -> array.add((Object)item.toJson()));
            json.put("partitions", array);
        }
    }
}

