/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.consumer;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.ReadStream;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.consumer.impl.KafkaReadStreamImpl;
import io.vertx.kafka.client.serialization.VertxSerdes;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;

public interface KafkaReadStream<K, V>
extends ReadStream<ConsumerRecord<K, V>> {
    public KafkaReadStream<K, V> exceptionHandler(Handler<Throwable> var1);

    public KafkaReadStream<K, V> handler(@Nullable Handler<ConsumerRecord<K, V>> var1);

    public KafkaReadStream<K, V> pause();

    public KafkaReadStream<K, V> resume();

    public KafkaReadStream<K, V> fetch(long var1);

    public KafkaReadStream<K, V> endHandler(@Nullable Handler<Void> var1);

    public long demand();

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Properties config) {
        return new KafkaReadStreamImpl(vertx, new KafkaConsumer(config), KafkaClientOptions.fromProperties(config, false));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Properties config, Class<K> keyType, Class<V> valueType) {
        Deserializer keyDeserializer = VertxSerdes.serdeFrom(keyType).deserializer();
        Deserializer valueDeserializer = VertxSerdes.serdeFrom(valueType).deserializer();
        return KafkaReadStream.create(vertx, config, keyDeserializer, valueDeserializer);
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Properties config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return new KafkaReadStreamImpl(vertx, new KafkaConsumer(config, keyDeserializer, valueDeserializer), KafkaClientOptions.fromProperties(config, false));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Map<String, Object> config) {
        return new KafkaReadStreamImpl(vertx, new KafkaConsumer(config), KafkaClientOptions.fromMap(config, false));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Map<String, Object> config, Class<K> keyType, Class<V> valueType) {
        Deserializer keyDeserializer = VertxSerdes.serdeFrom(keyType).deserializer();
        Deserializer valueDeserializer = VertxSerdes.serdeFrom(valueType).deserializer();
        return KafkaReadStream.create(vertx, config, keyDeserializer, valueDeserializer);
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Map<String, Object> config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return new KafkaReadStreamImpl(vertx, new KafkaConsumer(config, keyDeserializer, valueDeserializer), KafkaClientOptions.fromMap(config, false));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, KafkaClientOptions options) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (options.getConfig() != null) {
            config.putAll(options.getConfig());
        }
        return new KafkaReadStreamImpl(vertx, new KafkaConsumer(config), options);
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, KafkaClientOptions options, Class<K> keyType, Class<V> valueType) {
        Deserializer keyDeserializer = VertxSerdes.serdeFrom(keyType).deserializer();
        Deserializer valueDeserializer = VertxSerdes.serdeFrom(valueType).deserializer();
        return KafkaReadStream.create(vertx, options, keyDeserializer, valueDeserializer);
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, KafkaClientOptions options, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (options.getConfig() != null) {
            config.putAll(options.getConfig());
        }
        return new KafkaReadStreamImpl(vertx, new KafkaConsumer(config, keyDeserializer, valueDeserializer), options);
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Consumer<K, V> consumer) {
        return KafkaReadStream.create(vertx, consumer, new KafkaClientOptions());
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Consumer<K, V> consumer, KafkaClientOptions options) {
        return new KafkaReadStreamImpl<K, V>(vertx, consumer, options);
    }

    public Future<OffsetAndMetadata> committed(TopicPartition var1);

    public Future<Void> pause(Set<TopicPartition> var1);

    public Future<Set<TopicPartition>> paused();

    public Future<Void> resume(Set<TopicPartition> var1);

    public Future<Void> seekToEnd(Set<TopicPartition> var1);

    public Future<Void> seekToBeginning(Set<TopicPartition> var1);

    public Future<Void> seek(TopicPartition var1, long var2);

    public Future<Void> seek(TopicPartition var1, OffsetAndMetadata var2);

    public KafkaReadStream<K, V> partitionsRevokedHandler(Handler<Set<TopicPartition>> var1);

    public KafkaReadStream<K, V> partitionsAssignedHandler(Handler<Set<TopicPartition>> var1);

    public Future<Void> subscribe(Set<String> var1);

    public Future<Void> subscribe(Pattern var1);

    public Future<Void> unsubscribe();

    public Future<Set<String>> subscription();

    public Future<Void> assign(Set<TopicPartition> var1);

    public Future<Set<TopicPartition>> assignment();

    public Future<Map<String, List<PartitionInfo>>> listTopics();

    public Future<Map<TopicPartition, OffsetAndMetadata>> commit();

    public Future<Map<TopicPartition, OffsetAndMetadata>> commit(Map<TopicPartition, OffsetAndMetadata> var1);

    public Future<List<PartitionInfo>> partitionsFor(String var1);

    public Future<Void> close();

    public Future<Long> position(TopicPartition var1);

    public Future<Map<TopicPartition, OffsetAndTimestamp>> offsetsForTimes(Map<TopicPartition, Long> var1);

    public Future<OffsetAndTimestamp> offsetsForTimes(TopicPartition var1, long var2);

    public Future<Map<TopicPartition, Long>> beginningOffsets(Set<TopicPartition> var1);

    public Future<Long> beginningOffsets(TopicPartition var1);

    public Future<Map<TopicPartition, Long>> endOffsets(Set<TopicPartition> var1);

    public Future<Long> endOffsets(TopicPartition var1);

    public Consumer<K, V> unwrap();

    public KafkaReadStream<K, V> batchHandler(Handler<ConsumerRecords<K, V>> var1);

    public KafkaReadStream<K, V> pollTimeout(Duration var1);

    public Future<ConsumerRecords<K, V>> poll(Duration var1);
}

