/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.admin.Config;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.DescribeClusterOptions;
import io.vertx.kafka.admin.DescribeConsumerGroupsOptions;
import io.vertx.kafka.admin.DescribeTopicsOptions;
import io.vertx.kafka.admin.ListConsumerGroupOffsetsOptions;
import io.vertx.kafka.admin.ListOffsetsResultInfo;
import io.vertx.kafka.admin.NewPartitions;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.admin.OffsetSpec;
import io.vertx.kafka.admin.TopicDescription;
import io.vertx.kafka.admin.impl.KafkaAdminClientImpl;
import io.vertx.kafka.client.common.ConfigResource;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;

@VertxGen
public interface KafkaAdminClient {
    @GenIgnore
    public static KafkaAdminClient create(Vertx vertx, AdminClient adminClient) {
        return new KafkaAdminClientImpl(vertx, adminClient);
    }

    public static KafkaAdminClient create(Vertx vertx, Map<String, String> config) {
        return KafkaAdminClient.create(vertx, AdminClient.create(new HashMap<String, String>(config)));
    }

    @GenIgnore
    public static KafkaAdminClient create(Vertx vertx, Properties config) {
        return KafkaAdminClient.create(vertx, AdminClient.create((Properties)config));
    }

    public Future<Set<String>> listTopics();

    public Future<Map<String, TopicDescription>> describeTopics(List<String> var1);

    public Future<Map<String, TopicDescription>> describeTopics(List<String> var1, DescribeTopicsOptions var2);

    public Future<Void> createTopics(List<NewTopic> var1);

    public Future<Void> deleteTopics(List<String> var1);

    public Future<Void> createPartitions(Map<String, NewPartitions> var1);

    @GenIgnore
    public Future<Map<ConfigResource, Config>> describeConfigs(List<ConfigResource> var1);

    @GenIgnore
    public Future<Void> alterConfigs(Map<ConfigResource, Config> var1);

    public Future<List<ConsumerGroupListing>> listConsumerGroups();

    public Future<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> var1);

    public Future<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> var1, DescribeConsumerGroupsOptions var2);

    public Future<ClusterDescription> describeCluster();

    public Future<ClusterDescription> describeCluster(DescribeClusterOptions var1);

    @GenIgnore
    public Future<Map<Integer, Map<String, LogDirDescription>>> describeLogDirs(List<Integer> var1);

    @GenIgnore
    public Future<Map<TopicPartition, DeletedRecords>> deleteRecords(Map<TopicPartition, RecordsToDelete> var1);

    public Future<Void> deleteConsumerGroups(List<String> var1);

    @GenIgnore
    public Future<Map<TopicPartition, OffsetAndMetadata>> listConsumerGroupOffsets(String var1, ListConsumerGroupOffsetsOptions var2);

    @GenIgnore
    default public Future<Map<TopicPartition, OffsetAndMetadata>> listConsumerGroupOffsets(String groupId) {
        return this.listConsumerGroupOffsets(groupId, new ListConsumerGroupOffsetsOptions());
    }

    public Future<Void> deleteConsumerGroupOffsets(String var1, Set<TopicPartition> var2);

    @GenIgnore
    public Future<Void> alterConsumerGroupOffsets(String var1, Map<TopicPartition, OffsetAndMetadata> var2);

    @GenIgnore
    public Future<Map<TopicPartition, ListOffsetsResultInfo>> listOffsets(Map<TopicPartition, OffsetSpec> var1);

    @GenIgnore(value={"permitted-type"})
    public Future<List<AclBinding>> describeAcls(AclBindingFilter var1);

    @GenIgnore(value={"permitted-type"})
    public Future<List<AclBinding>> createAcls(List<AclBinding> var1);

    @GenIgnore(value={"permitted-type"})
    public Future<List<AclBinding>> deleteAcls(List<AclBindingFilter> var1);

    public Future<Void> close();

    public Future<Void> close(long var1);
}

