/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import groovy.lang.Binding;
import groovy.lang.MetaMethod;
import groovy.lang.Script;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;

public class ScriptVerticle
extends AbstractVerticle {
    private final Script script;
    private static final Class[] EMPTY_PARAMS = new Class[0];
    private static final Class[] FUTURE_PARAMS = new Class[]{Promise.class};

    public ScriptVerticle(Script script) {
        this.script = script;
    }

    public void start(Promise<Void> startPromise) throws Exception {
        Binding binding = this.script.getBinding();
        if (this.script.getBinding() == null) {
            binding = new Binding();
            this.script.setBinding(binding);
        }
        binding.setVariable("vertx", (Object)this.vertx);
        this.script.run();
        this.handleLifecycle("vertxStart", startPromise);
    }

    public void stop(Promise<Void> stopPromise) throws Exception {
        this.handleLifecycle("vertxStop", stopPromise);
    }

    private void handleLifecycle(String methodName, Promise<Void> promise) {
        MetaMethod method = this.script.getMetaClass().getMetaMethod(methodName, (Object[])EMPTY_PARAMS);
        if (method != null) {
            if (method.isValidMethod(FUTURE_PARAMS)) {
                method.invoke((Object)this.script, new Object[]{promise});
            } else if (method.isValidMethod(EMPTY_PARAMS)) {
                method.invoke((Object)this.script, (Object[])EMPTY_PARAMS);
                promise.complete();
            }
        } else {
            promise.complete();
        }
    }
}

