/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.launcher.application;

import io.vertx.core.Deployable;
import io.vertx.core.Vertx;
import io.vertx.core.VertxBuilder;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.launcher.application.HookContext;
import java.util.function.Supplier;

public interface VertxApplicationHooks {
    public static final VertxApplicationHooks DEFAULT = new VertxApplicationHooks(){};

    default public JsonObject afterVertxOptionsParsed(JsonObject vertxOptions) {
        return vertxOptions;
    }

    default public JsonObject afterDeploymentOptionsParsed(JsonObject deploymentOptions) {
        return deploymentOptions;
    }

    default public JsonObject afterConfigParsed(JsonObject config) {
        return config;
    }

    default public void beforeStartingVertx(HookContext context) {
    }

    default public VertxBuilder createVertxBuilder(VertxOptions options) {
        return Vertx.builder().with(options);
    }

    default public void afterVertxStarted(HookContext context) {
    }

    default public void afterFailureToStartVertx(HookContext context, Throwable t) {
    }

    default public Supplier<? extends Deployable> verticleSupplier() {
        return null;
    }

    default public void beforeDeployingVerticle(HookContext context) {
    }

    default public void afterVerticleDeployed(HookContext context) {
    }

    default public void afterFailureToDeployVerticle(HookContext context, Throwable t) {
        context.vertx().close();
    }

    default public void beforeStoppingVertx(HookContext context) {
    }

    default public void afterVertxStopped(HookContext context) {
    }

    default public void afterFailureToStopVertx(HookContext context, Throwable t) {
    }
}

