/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.launcher.application.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class ShutdownHook
implements Runnable {
    private final Vertx vertx;
    private final Consumer<AsyncResult<Void>> whenComplete;

    public ShutdownHook(Vertx vertx, Consumer<AsyncResult<Void>> whenComplete) {
        this.vertx = vertx;
        this.whenComplete = whenComplete;
    }

    @Override
    public void run() {
        try {
            this.whenComplete.accept(this.closeVertx());
        }
        catch (ExecutionException e) {
            this.whenComplete.accept((AsyncResult<Void>)Future.failedFuture((Throwable)e.getCause()));
        }
        catch (TimeoutException e) {
            this.whenComplete.accept(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncResult<Void> closeVertx() throws ExecutionException, TimeoutException {
        CompletableFuture future = this.vertx.close().toCompletionStage().toCompletableFuture();
        long remaining = Duration.ofMinutes(2L).toMillis();
        long stop = System.currentTimeMillis() + remaining;
        boolean interrupted = false;
        while (true) {
            try {
                if (remaining >= 0L) {
                    future.get(remaining, TimeUnit.MILLISECONDS);
                    Future future2 = Future.succeededFuture();
                    return future2;
                }
                AsyncResult<Void> asyncResult = null;
                return asyncResult;
            }
            catch (InterruptedException e) {
                interrupted = true;
                remaining = stop - System.currentTimeMillis();
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }
}

