/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.parsetools.RecordParser;
import java.util.regex.Pattern;

public class MultilineParser
implements Handler<Buffer> {
    private static final Pattern STATUS_LINE_CONTINUE = Pattern.compile("^\\d{3}-.*");
    private static final Logger log = LoggerFactory.getLogger(MultilineParser.class);
    private boolean initialized = false;
    private Buffer result;
    private final RecordParser rp;
    private int expected = 1;
    private int actual = 0;

    public MultilineParser(final Handler<Buffer> output) {
        Handler<Buffer> mlp = new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                if (!MultilineParser.this.initialized) {
                    MultilineParser.this.initialized = true;
                    String line = buffer.toString();
                    if (line.endsWith("\r")) {
                        log.debug((Object)"setting crlf line mode");
                        MultilineParser.this.rp.delimitedMode("\r\n");
                        this.appendOrHandle(Buffer.buffer((String)line.substring(0, line.length() - 1)));
                    } else {
                        this.appendOrHandle(buffer);
                    }
                } else {
                    this.appendOrHandle(buffer);
                }
            }

            private void appendOrHandle(Buffer buffer) {
                if (MultilineParser.this.result == null) {
                    MultilineParser.this.result = Buffer.buffer();
                }
                MultilineParser.this.result.appendBuffer(buffer);
                if (MultilineParser.this.isFinalLine(buffer)) {
                    ++MultilineParser.this.actual;
                    if (MultilineParser.this.actual < MultilineParser.this.expected) {
                        MultilineParser.this.result.appendString("\r\n");
                    } else if (MultilineParser.this.actual == MultilineParser.this.expected) {
                        try {
                            output.handle((Object)MultilineParser.this.result);
                        }
                        finally {
                            MultilineParser.this.result = null;
                            MultilineParser.this.actual = 0;
                        }
                    }
                } else {
                    MultilineParser.this.result.appendString("\n");
                }
            }
        };
        this.rp = RecordParser.newDelimited((String)"\n", (Handler)mlp);
    }

    public boolean isFinalLine(Buffer buffer) {
        String line = buffer.toString();
        if (line.contains("\n")) {
            String[] lines = line.split("\n");
            line = lines[lines.length - 1];
        }
        return !STATUS_LINE_CONTINUE.matcher(line).matches();
    }

    public void handle(Buffer event) {
        this.rp.handle(event);
    }

    public MultilineParser setExpected(int expected) {
        this.expected = expected;
        return this;
    }
}

