/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl.dkim;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.mail.CanonicalizationAlgorithm;
import io.vertx.ext.mail.DKIMSignOptions;
import io.vertx.ext.mail.mailencoder.EncodedPart;
import io.vertx.ext.mail.mailencoder.Utils;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DKIMSigner {
    public static final String DKIM_SIGNATURE_HEADER = "DKIM-Signature";
    private static final Logger logger = LoggerFactory.getLogger(DKIMSigner.class);
    private final DKIMSignOptions dkimSignOptions;
    private final String signatureTemplate;
    private final Signature signatureService;
    private static final Pattern DELIMITER = Pattern.compile("\n");

    public DKIMSigner(DKIMSignOptions dkimSignOptions, Vertx vertx) {
        this.dkimSignOptions = dkimSignOptions;
        this.validate(this.dkimSignOptions);
        this.signatureTemplate = this.dkimSignatureTemplate();
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            String secretKey = dkimSignOptions.getPrivateKey();
            if (secretKey == null) {
                secretKey = vertx.fileSystem().readFileBlocking(dkimSignOptions.getPrivateKeyPath()).toString();
            }
            PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(secretKey));
            PrivateKey privateKey = kf.generatePrivate(keyspec);
            this.signatureService = Signature.getInstance(dkimSignOptions.getSignAlgo().signatureAlgorithm());
            this.signatureService.initSign(privateKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("Failed to init the Signature", e);
        }
    }

    private void validate(DKIMSignOptions ops) throws IllegalStateException {
        this.checkRequiredFields(ops);
        String auid = ops.getAuid();
        if (auid != null) {
            String sdid = ops.getSdid();
            if (!auid.toLowerCase().endsWith("@" + sdid.toLowerCase()) && !auid.toLowerCase().endsWith("." + sdid.toLowerCase())) {
                throw new IllegalStateException("Identity domain mismatch, expected is: [xx]@[xx.]sdid");
            }
        }
        if (ops.getSignedHeaders().stream().noneMatch(h -> h.equalsIgnoreCase("from"))) {
            throw new IllegalStateException("From field must be selected to sign.");
        }
    }

    private void checkRequiredFields(DKIMSignOptions ops) {
        if (ops.getSignAlgo() == null) {
            throw new IllegalStateException("Sign Algorithm is required: rsa-sha1 or rsa-sha256");
        }
        if (ops.getPrivateKey() == null && ops.getPrivateKeyPath() == null) {
            throw new IllegalStateException("Either private key or private key file path must be specified to sign");
        }
        if (ops.getSignedHeaders() == null || ops.getSignedHeaders().isEmpty()) {
            throw new IllegalStateException("Email header fields to sign must be set");
        }
        if (ops.getSdid() == null) {
            throw new IllegalStateException("Singing Domain Identifier(SDID) must be specified");
        }
        if (ops.getSelector() == null) {
            throw new IllegalStateException("The selector must be specified to be able to verify");
        }
    }

    public String dkimSignatureTemplate() {
        StringBuilder sb = new StringBuilder();
        sb.append("v=1; ");
        sb.append("a=").append(this.dkimSignOptions.getSignAlgo().dkimAlgoName()).append("; ");
        CanonicalizationAlgorithm bodyCanonic = this.dkimSignOptions.getBodyCanonAlgo();
        CanonicalizationAlgorithm headerCanonic = this.dkimSignOptions.getHeaderCanonAlgo();
        sb.append("c=").append(headerCanonic.algoName()).append("/").append(bodyCanonic.algoName()).append("; ");
        String sdid = DKIMSigner.dkimQuotedPrintable(this.dkimSignOptions.getSdid());
        sb.append("d=").append(sdid).append("; ");
        String auid = this.dkimSignOptions.getAuid();
        if (auid != null) {
            sb.append("i=").append(DKIMSigner.dkimQuotedPrintable(auid)).append("; ");
        } else {
            sb.append("i=").append("@").append(sdid).append("; ");
        }
        sb.append("s=").append(DKIMSigner.dkimQuotedPrintable(this.dkimSignOptions.getSelector())).append("; ");
        String signHeadersString = String.join((CharSequence)":", this.dkimSignOptions.getSignedHeaders());
        sb.append("h=").append(signHeadersString).append("; ");
        if (this.dkimSignOptions.getBodyLimit() > 0) {
            sb.append("l=").append(this.dkimSignOptions.getBodyLimit()).append("; ");
        }
        if (this.dkimSignOptions.isSignatureTimestamp() || this.dkimSignOptions.getExpireTime() > 0L) {
            long time = System.currentTimeMillis() / 1000L;
            sb.append("t=").append(time).append("; ");
            if (this.dkimSignOptions.getExpireTime() > 0L) {
                long expire = time + this.dkimSignOptions.getExpireTime();
                sb.append("x=").append(expire).append("; ");
            }
        }
        return sb.toString();
    }

    public Future<String> signEmail(Context context, EncodedPart encodedMessage) {
        return this.bodyHashing((ContextInternal)context, encodedMessage).map(bh -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DKIM Body Hash: " + bh));
            }
            try {
                String returnStr;
                StringBuilder dkimTagListBuilder = this.dkimTagList(encodedMessage).append("bh=").append((String)bh).append("; b=");
                String dkimSignHeaderCanonic = this.canonicHeader(DKIM_SIGNATURE_HEADER, dkimTagListBuilder.toString());
                String tobeSigned = this.headersToSign(encodedMessage).append(dkimSignHeaderCanonic).toString();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("To be signed DKIM header: " + tobeSigned));
                }
                Signature signature = this.signatureService;
                synchronized (signature) {
                    this.signatureService.update(tobeSigned.getBytes());
                    String sig = Base64.getEncoder().encodeToString(this.signatureService.sign());
                    returnStr = dkimTagListBuilder.append(sig).toString();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("DKIM-Signature: " + returnStr));
                }
                return returnStr;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot sign email", e);
            }
        });
    }

    private void walkThroughAttachStream(final MessageDigest md, ReadStream<Buffer> stream, final AtomicInteger written, Promise<Void> promise) {
        Pipe pipe = stream.pipe();
        Promise pipePromise = Promise.promise();
        pipePromise.future().onComplete(pr -> {
            pipe.close();
            if (pr.succeeded()) {
                promise.complete();
            } else {
                promise.fail(pr.cause());
            }
        });
        pipe.to((WriteStream)new WriteStream<Buffer>(){
            private final AtomicBoolean ended = new AtomicBoolean(false);

            public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
                return this;
            }

            public Future<Void> write(Buffer data) {
                if (!this.ended.get() && !DKIMSigner.this.digest(md, data.getBytes(), written)) {
                    this.ended.set(true);
                }
                return Future.succeededFuture();
            }

            public Future<Void> end() {
                this.ended.set(true);
                return Future.succeededFuture();
            }

            public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
                return this;
            }

            public boolean writeQueueFull() {
                return false;
            }

            public WriteStream<Buffer> drainHandler(@Nullable Handler<Void> handler) {
                return this;
            }
        }).onComplete((Completable)pipePromise);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean digest(MessageDigest md, byte[] bytes, AtomicInteger written) {
        if (this.dkimSignOptions.getBodyLimit() > 0) {
            int left = this.dkimSignOptions.getBodyLimit() - written.get();
            if (left <= 0) return false;
            int len = Math.min(left, bytes.length);
            md.update(bytes, 0, len);
            written.getAndAdd(len);
            return true;
        } else {
            md.update(bytes);
        }
        return true;
    }

    private Future<Boolean> walkBoundaryStartAndHeadersFuture(MessageDigest md, String boundaryStart, EncodedPart part, AtomicInteger written) {
        Promise promise = Promise.promise();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(boundaryStart);
            part.headers().forEach(entry -> sb.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\r\n"));
            sb.append("\r\n");
            promise.complete((Object)this.digest(md, sb.toString().getBytes(), written));
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    private void walkThroughMultiPart(Context context, MessageDigest md, EncodedPart multiPart, int index, AtomicInteger written, Promise<Void> promise) {
        String boundaryStart = "--" + multiPart.boundary() + "\r\n";
        String boundaryEnd = "--" + multiPart.boundary() + "--";
        if (index < multiPart.parts().size()) {
            EncodedPart part = multiPart.parts().get(index);
            Promise nextPartPromise = Promise.promise();
            nextPartPromise.future().onComplete(r -> {
                if (r.succeeded()) {
                    this.walkThroughMultiPart(context, md, multiPart, index + 1, written, promise);
                } else {
                    promise.fail(r.cause());
                }
            });
            this.walkBoundaryStartAndHeadersFuture(md, boundaryStart, part, written).onComplete(r -> {
                if (r.succeeded()) {
                    if (((Boolean)r.result()).booleanValue()) {
                        if (part.parts() != null && part.parts().size() > 0) {
                            this.walkThroughMultiPart(context, md, part, 0, written, (Promise<Void>)nextPartPromise);
                        } else if (part.body() != null) {
                            String canonicBody = this.dkimMailBody(part.body());
                            this.digest(md, canonicBody.getBytes(), written);
                            nextPartPromise.complete();
                        } else {
                            ReadStream<Buffer> dkimAttachStream = part.dkimBodyStream(context);
                            if (dkimAttachStream != null) {
                                this.walkThroughAttachStream(md, dkimAttachStream, written, (Promise<Void>)nextPartPromise);
                            } else {
                                nextPartPromise.fail("No data and stream found.");
                            }
                        }
                    } else {
                        promise.complete();
                    }
                } else {
                    promise.fail(r.cause());
                }
            });
        } else {
            this.digest(md, (boundaryEnd + "\r\n").getBytes(), written);
            promise.complete();
        }
    }

    private Future<String> bodyHashing(ContextInternal context, EncodedPart encodedMessage) {
        PromiseInternal bodyHashPromise = context.promise();
        try {
            MessageDigest md = MessageDigest.getInstance(this.dkimSignOptions.getSignAlgo().hashAlgorithm());
            if (encodedMessage.parts() != null && encodedMessage.parts().size() > 0) {
                PromiseInternal multiPartWalkThrough = context.promise();
                multiPartWalkThrough.future().onComplete(arg_0 -> DKIMSigner.lambda$bodyHashing$6(md, (Promise)bodyHashPromise, arg_0));
                this.walkThroughMultiPart((Context)context, md, encodedMessage, 0, new AtomicInteger(), (Promise<Void>)multiPartWalkThrough);
            } else {
                String canonicBody = this.dkimMailBody(encodedMessage.body());
                this.digest(md, canonicBody.getBytes(), new AtomicInteger());
                String bh = Base64.getEncoder().encodeToString(md.digest());
                bodyHashPromise.complete((Object)bh);
            }
        }
        catch (Exception e) {
            bodyHashPromise.fail((Throwable)e);
        }
        return bodyHashPromise.future();
    }

    private StringBuilder headersToSign(EncodedPart encodedMessage) {
        StringBuilder signHeaders = new StringBuilder();
        HashMap<String, Integer> valueIdx = new HashMap<String, Integer>();
        for (String header : this.dkimSignOptions.getSignedHeaders()) {
            int idx;
            List values = encodedMessage.headers().getAll(header);
            int size = values.size();
            if (size <= 0 || (idx = valueIdx.computeIfAbsent(header.toUpperCase(Locale.ENGLISH), s -> size - 1).intValue()) < 0) continue;
            signHeaders.append(this.canonicHeader(header, (String)values.get(idx))).append("\r\n");
            valueIdx.put(header.toUpperCase(Locale.ENGLISH), idx - 1);
        }
        return signHeaders;
    }

    private StringBuilder dkimTagList(EncodedPart encodedMessage) {
        StringBuilder dkimTagList = new StringBuilder(this.signatureTemplate);
        if (this.dkimSignOptions.getCopiedHeaders() != null && this.dkimSignOptions.getCopiedHeaders().size() > 0) {
            dkimTagList.append("z=").append(this.copiedHeaders(this.dkimSignOptions.getCopiedHeaders(), encodedMessage)).append("; ");
        }
        return dkimTagList;
    }

    private String copiedHeaders(List<String> headers, EncodedPart encodedMessage) {
        return headers.stream().map(h -> {
            String hValue = encodedMessage.headers().get(h);
            if (hValue != null) {
                return h + ":" + this.dkimQuotedPrintableCopiedHeader(hValue);
            }
            throw new RuntimeException("Unknown email header: " + h + " in copied headers.");
        }).collect(Collectors.joining("|"));
    }

    private static String dkimQuotedPrintable(String str) {
        String dkimStr = Utils.encodeQP(str);
        dkimStr = dkimStr.replaceAll(";", "=3B");
        dkimStr = dkimStr.replaceAll(" ", "=20");
        return dkimStr;
    }

    private String dkimQuotedPrintableCopiedHeader(String value) {
        return DKIMSigner.dkimQuotedPrintable(value).replaceAll("\\|", "=7C");
    }

    public String canonicHeader(String emailHeaderName, String emailHeaderValue) {
        if (this.dkimSignOptions.getHeaderCanonAlgo() == CanonicalizationAlgorithm.SIMPLE) {
            return emailHeaderName + ": " + emailHeaderValue;
        }
        String headerName = emailHeaderName.trim().toLowerCase();
        return headerName + ":" + this.canonicalLine(emailHeaderValue, this.dkimSignOptions.getHeaderCanonAlgo());
    }

    public String dkimMailBody(String mailBody) {
        Scanner scanner = new Scanner(mailBody).useDelimiter(DELIMITER);
        StringBuilder sb = new StringBuilder();
        while (scanner.hasNext()) {
            sb.append(this.canonicBodyLine(scanner.nextLine()));
            sb.append("\r\n");
        }
        return sb.toString().replaceFirst("[\r\n]*$", "\r\n");
    }

    private String canonicalLine(String line, CanonicalizationAlgorithm canon) {
        if (CanonicalizationAlgorithm.RELAXED == canon) {
            line = line.replaceAll("[\r\n\t ]+", " ");
            line = line.replaceAll("[\r\n\t ]+$", "");
        }
        return line;
    }

    public String canonicBodyLine(String line) {
        return this.canonicalLine(line, this.dkimSignOptions.getBodyCanonAlgo());
    }

    private static /* synthetic */ void lambda$bodyHashing$6(MessageDigest md, Promise bodyHashPromise, AsyncResult r) {
        if (r.succeeded()) {
            try {
                String bh = Base64.getEncoder().encodeToString(md.digest());
                bodyHashPromise.complete((Object)bh);
            }
            catch (Exception e) {
                bodyHashPromise.fail((Throwable)e);
            }
        } else {
            bodyHashPromise.fail(r.cause());
        }
    }
}

