/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl.sasl;

import io.vertx.ext.mail.impl.sasl.AuthBaseClass;
import io.vertx.ext.mail.impl.sasl.NTLMEngineException;
import io.vertx.ext.mail.impl.sasl.NTLMEngineImpl;

public class NTLMAuth
extends AuthBaseClass {
    private final NTLMEngineImpl ntlmEngine = new NTLMEngineImpl();
    private boolean firstStep = true;
    private boolean finished = false;
    private final String domain;
    private final String workstation;

    public NTLMAuth(String username, String password, String domain, String workstation) {
        super("NTLM", username, password);
        this.domain = domain;
        this.workstation = workstation;
    }

    @Override
    public String nextStep(String data) {
        if (this.finished) {
            return null;
        }
        try {
            if (this.firstStep) {
                this.firstStep = false;
                return this.ntlmEngine.generateType1Msg(this.domain, this.workstation);
            }
            this.finished = true;
            return this.ntlmEngine.generateType3Msg(this.username, this.password.toCharArray(), this.domain, this.workstation, data);
        }
        catch (NTLMEngineException e) {
            throw new RuntimeException("Failed to generate NTLM response message", e);
        }
    }

    @Override
    public boolean handleCoding() {
        return true;
    }

    public String domain() {
        return this.domain;
    }

    public String workstation() {
        return this.workstation;
    }
}

