/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.mailencoder;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.mail.MailAttachment;
import io.vertx.ext.mail.mailencoder.EncodedPart;
import io.vertx.ext.mail.mailencoder.Utils;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

class AttachmentPart
extends EncodedPart {
    private static final Logger log = LoggerFactory.getLogger(AttachmentPart.class);
    private static final boolean CACHE_IN_FILE = Boolean.getBoolean("vertx.mail.attachment.cache.file");
    private String cachedFilePath;
    private final MailAttachment attachment;

    AttachmentPart(MailAttachment attachment) {
        this.attachment = attachment;
        if (this.attachment.getData() == null && this.attachment.getStream() == null) {
            throw new IllegalArgumentException("Either data or stream of the attachment cannot be null");
        }
        if (this.attachment.getStream() != null && this.attachment.getSize() < 0) {
            log.warn((Object)"Size of the attachment should be specified when using stream");
        }
        this.headers = MultiMap.caseInsensitiveMultiMap();
        String name = attachment.getName();
        Object contentType = attachment.getContentType() != null ? attachment.getContentType() : "application/octet-stream";
        if (name != null) {
            int index = ((String)contentType).length() + 22;
            contentType = (String)contentType + "; name=\"" + Utils.encodeHeader(name, index) + "\"";
        }
        this.headers.set("Content-Type", (String)contentType);
        this.headers.set("Content-Transfer-Encoding", "base64");
        if (attachment.getDescription() != null) {
            this.headers.set("Content-Description", attachment.getDescription());
        }
        Object disposition = attachment.getDisposition() != null ? attachment.getDisposition() : "attachment";
        if (name != null) {
            int index = ((String)disposition).length() + 33;
            disposition = (String)disposition + "; filename=\"" + Utils.encodeHeader(name, index) + "\"";
        }
        this.headers.set("Content-Disposition", (String)disposition);
        if (attachment.getContentId() != null) {
            this.headers.set("Content-ID", attachment.getContentId());
        }
        if (attachment.getHeaders() != null) {
            this.headers.addAll(attachment.getHeaders());
        }
        if (attachment.getData() != null) {
            this.part = Utils.base64(attachment.getData().getBytes());
        }
    }

    @Override
    public synchronized ReadStream<Buffer> bodyStream(Context context) {
        ReadStream<Buffer> attachStream = this.attachment.getStream();
        if (attachStream == null) {
            return null;
        }
        return new BodyReadStream(context, attachStream, false);
    }

    @Override
    public synchronized ReadStream<Buffer> dkimBodyStream(Context context) {
        ReadStream<Buffer> attachStream = this.attachment.getStream();
        if (attachStream == null) {
            return null;
        }
        return new BodyReadStream(context, attachStream, true);
    }

    @Override
    public int size() {
        if (this.attachment.getData() == null) {
            return this.attachment.getSize() < 0 ? 0 : this.attachment.getSize() / 3 * 4;
        }
        return super.size();
    }

    private class BodyReadStream
    implements ReadStream<Buffer> {
        private final Context context;
        private final ReadStream<Buffer> stream;
        private Handler<Throwable> exceptionHandler;
        private final boolean cacheInMemory;
        private final Buffer cachedBuffer;
        private final boolean cacheInFile;
        private final String cachedFilePath;
        private AsyncFile cachedFile;
        private static final String cacheFilePrefix = "_vertx_mail_attach_";
        private static final String cachFileSuffix = ".data";
        private final int size = 57;
        private Buffer streamBuffer;
        private Handler<Buffer> handler;
        private Handler<Void> endHandler;
        private boolean caching;
        private final AtomicBoolean streamEnded = new AtomicBoolean();

        private BodyReadStream(Context context, ReadStream<Buffer> stream, boolean tryReset) {
            Objects.requireNonNull(stream, "ReadStream cannot be null");
            this.stream = stream;
            this.context = context;
            this.streamBuffer = Buffer.buffer();
            if (tryReset) {
                if (CACHE_IN_FILE) {
                    this.cacheInFile = true;
                    this.cachedFilePath = context.owner().fileSystem().createTempFileBlocking(cacheFilePrefix, cachFileSuffix);
                    this.cacheInMemory = false;
                    this.cachedBuffer = null;
                } else {
                    this.cacheInFile = false;
                    this.cachedFilePath = null;
                    this.cacheInMemory = true;
                    this.cachedBuffer = Buffer.buffer();
                }
            } else {
                this.cacheInMemory = false;
                this.cachedBuffer = null;
                this.cacheInFile = false;
                this.cachedFilePath = null;
            }
        }

        public synchronized BodyReadStream exceptionHandler(Handler<Throwable> handler) {
            if (handler != null) {
                this.stream.exceptionHandler(handler);
                this.exceptionHandler = handler;
            }
            return this;
        }

        public synchronized BodyReadStream handler(@Nullable Handler<Buffer> handler) {
            if (handler == null) {
                this.stream.handler(null);
                return this;
            }
            this.handler = handler;
            this.stream.handler(b -> {
                if (this.streamEnded.get()) {
                    this.handleEventInContext(this.exceptionHandler, new IllegalStateException("Stream has been closed, no more reading."));
                    return;
                }
                Buffer buffer = this.streamBuffer.appendBuffer(b);
                Buffer bufferToSent = Buffer.buffer();
                int start = 0;
                while (start + 57 < buffer.length()) {
                    String theLine = Utils.base64(buffer.getBytes(start, start + 57));
                    bufferToSent.appendBuffer(Buffer.buffer((String)(theLine + "\r\n")));
                    start += 57;
                }
                this.streamBuffer = buffer.getBuffer(start, buffer.length());
                this.handleEventInContext(this.handler, bufferToSent);
                if (this.cacheInMemory || this.cacheInFile) {
                    this.cacheBuffer((Buffer)b).onComplete(r -> {
                        BodyReadStream bodyReadStream = this;
                        synchronized (bodyReadStream) {
                            this.caching = false;
                            if (r.failed()) {
                                this.handleEventInContext(this.exceptionHandler, r.cause());
                            }
                            this.checkEnd();
                        }
                    });
                }
            });
            return this;
        }

        private synchronized Future<Void> cacheBuffer(Buffer buffer) {
            this.caching = true;
            Promise promise = Promise.promise();
            if (this.cacheInMemory) {
                this.cachedBuffer.appendBuffer(buffer);
                promise.complete();
            } else if (this.cachedFile == null) {
                this.context.owner().fileSystem().open(this.cachedFilePath, new OpenOptions().setAppend(true)).onComplete(c -> this.context.runOnContext(h -> {
                    if (c.succeeded()) {
                        BodyReadStream bodyReadStream = this;
                        synchronized (bodyReadStream) {
                            this.cachedFile = (AsyncFile)c.result();
                            this.cachedFile.write((Object)buffer).onComplete((Completable)promise);
                        }
                    } else {
                        promise.fail(c.cause());
                    }
                }));
            } else {
                this.cachedFile.write((Object)buffer).onComplete((Completable)promise);
            }
            return promise.future();
        }

        private synchronized void checkEnd() {
            if (this.streamEnded.get() && !this.caching) {
                if (this.cacheInFile) {
                    AttachmentPart.this.attachment.setStream((ReadStream<Buffer>)this.cachedFile);
                    AttachmentPart.this.cachedFilePath = this.cachedFilePath;
                    this.handleEventInContext(this.endHandler, null);
                } else if (this.cacheInMemory) {
                    AttachmentPart.this.part = Utils.base64(this.cachedBuffer.getBytes());
                    this.handleEventInContext(this.endHandler, null);
                } else if (AttachmentPart.this.cachedFilePath != null) {
                    String tmpPath = AttachmentPart.this.cachedFilePath;
                    AttachmentPart.this.cachedFilePath = null;
                    this.context.owner().fileSystem().delete(tmpPath).onComplete(deleteCacheFile -> {
                        if (deleteCacheFile.succeeded()) {
                            this.handleEventInContext(this.endHandler, null);
                        } else {
                            new File(tmpPath).deleteOnExit();
                            this.handleEventInContext(this.exceptionHandler, deleteCacheFile.cause());
                        }
                    });
                } else {
                    this.handleEventInContext(this.endHandler, null);
                }
            }
        }

        public synchronized BodyReadStream pause() {
            this.stream.pause();
            return this;
        }

        public synchronized BodyReadStream resume() {
            this.stream.resume();
            return this;
        }

        public synchronized BodyReadStream fetch(long amount) {
            this.stream.fetch(amount);
            return this;
        }

        public synchronized BodyReadStream endHandler(@Nullable Handler<Void> endHandler) {
            if (endHandler == null) {
                this.stream.endHandler(null);
                return this;
            }
            this.endHandler = endHandler;
            this.stream.endHandler(v -> {
                if (!this.streamEnded.compareAndSet(false, true)) {
                    return;
                }
                if (this.streamBuffer.length() > 0 && this.handler != null) {
                    String theLine = Utils.base64(this.streamBuffer.getBytes());
                    Buffer buffer = Buffer.buffer((String)(theLine + "\r\n"));
                    this.handleEventInContext(this.handler, buffer);
                }
                this.checkEnd();
            });
            return this;
        }

        private <T> void handleEventInContext(Handler<T> handler, T t) {
            if (handler != null) {
                this.context.runOnContext(h -> handler.handle(t));
            }
        }
    }
}

