/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.maven.plugin.mojo;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.vertx.java.core.json.JsonObject;

public abstract class BaseVertxMojo
extends AbstractMojo {
    @Parameter(property="run.moduleName", defaultValue="${project.groupId}~${project.artifactId}~${project.version}")
    protected String moduleName;
    @Parameter(property="run.configFile")
    protected String configFile;
    @Parameter(property="run.instances", defaultValue="1")
    protected Integer instances;
    @Parameter(property="vertx.modsdir", defaultValue="target/mods")
    protected File modsdir;

    protected JsonObject getConf() {
        JsonObject config = null;
        String confContent = this.readConfigFile(this.configFile);
        if (confContent != null && !confContent.isEmpty()) {
            config = new JsonObject(confContent);
        }
        return config;
    }

    private String readConfigFile(String strFile) {
        if (strFile == null || strFile.isEmpty()) {
            return null;
        }
        try {
            File file = new File(strFile);
            URI uri = file.toURI();
            return new String(Files.readAllBytes(Paths.get(uri)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

