/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.maven.plugin.mojo;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.platform.PlatformLocator;
import org.vertx.java.platform.PlatformManager;
import org.vertx.maven.plugin.mojo.BaseVertxMojo;

@Mojo(name="pullindeps", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class VertxPullInDepsMojo
extends BaseVertxMojo {
    @Parameter(property="vertx.pullindeps", defaultValue="false")
    protected Boolean pullindeps;

    public void execute() throws MojoExecutionException {
        try {
            if (this.pullindeps.booleanValue()) {
                System.setProperty("vertx.mods", this.modsdir.getAbsolutePath());
                PlatformManager pm = PlatformLocator.factory.createPlatformManager();
                final CountDownLatch latch = new CountDownLatch(1);
                pm.pullInDependencies(this.moduleName, (Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> event) {
                        if (event.succeeded()) {
                            latch.countDown();
                        } else {
                            if (event.cause() != null) {
                                VertxPullInDepsMojo.this.getLog().error(event.cause());
                            } else {
                                VertxPullInDepsMojo.this.getLog().info((CharSequence)"Cannot find the module. Did you forget to do mvn package?");
                            }
                            latch.countDown();
                        }
                    }
                });
                latch.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

