/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.maven.plugin.mojo;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.platform.PlatformLocator;
import org.vertx.java.platform.PlatformManager;
import org.vertx.maven.plugin.mojo.BaseVertxMojo;

@Mojo(name="runmod", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class VertxRunModMojo
extends BaseVertxMojo {
    public void execute() throws MojoExecutionException {
        try {
            System.setProperty("vertx.mods", this.modsdir.getAbsolutePath());
            PlatformManager pm = PlatformLocator.factory.createPlatformManager();
            final CountDownLatch latch = new CountDownLatch(1);
            pm.deployModule(this.moduleName, this.getConf(), this.instances.intValue(), (Handler)new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> event) {
                    if (event.succeeded()) {
                        VertxRunModMojo.this.getLog().info((CharSequence)"CTRL-C to stop server");
                    } else {
                        if (event.cause() != null) {
                            VertxRunModMojo.this.getLog().error(event.cause());
                        } else {
                            VertxRunModMojo.this.getLog().info((CharSequence)"Could not find the module. Did you forget to do mvn package?");
                        }
                        latch.countDown();
                    }
                }
            });
            latch.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

