/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.HttpUtils;
import io.vertx.micrometer.impl.VertxNetClientMetrics;
import io.vertx.micrometer.impl.tags.Labels;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

class VertxHttpClientMetrics
extends VertxNetClientMetrics
implements HttpClientMetrics<RequestMetric, LongAdder, VertxNetClientMetrics.NetClientSocketMetric> {
    private final Function<HttpRequest, Iterable<Tag>> customTagsProvider;
    private final Meter.MeterProvider<Counter> requestCount;
    private final Meter.MeterProvider<DistributionSummary> requestBytes;
    private final Meter.MeterProvider<Timer> responseTime;
    private final Meter.MeterProvider<Counter> responseCount;
    private final Meter.MeterProvider<DistributionSummary> responseBytes;

    VertxHttpClientMetrics(AbstractMetrics parent, Function<HttpRequest, Iterable<Tag>> customTagsProvider, String localAddress) {
        super(parent, MetricsDomain.HTTP_CLIENT, localAddress);
        this.customTagsProvider = customTagsProvider;
        this.requestCount = Counter.builder((String)this.names.getHttpRequestsCount()).description("Number of requests sent").withRegistry(this.registry);
        this.requestBytes = DistributionSummary.builder((String)this.names.getHttpRequestBytes()).description("Size of requests in bytes").withRegistry(this.registry);
        this.responseTime = Timer.builder((String)this.names.getHttpResponseTime()).description("Response time").withRegistry(this.registry);
        this.responseCount = Counter.builder((String)this.names.getHttpResponsesCount()).description("Response count with codes").withRegistry(this.registry);
        this.responseBytes = DistributionSummary.builder((String)this.names.getHttpResponseBytes()).description("Size of responses in bytes").withRegistry(this.registry);
    }

    public ClientMetrics<RequestMetric, HttpRequest, HttpResponse> createEndpointMetrics(SocketAddress remoteAddress, int maxPoolSize) {
        Tags endPointTags = this.local;
        if (this.enabledLabels.contains((Object)Label.REMOTE)) {
            endPointTags = endPointTags.and(Label.REMOTE.toString(), Labels.address(remoteAddress));
        }
        return new EndpointMetrics(endPointTags);
    }

    public LongAdder connected(WebSocket webSocket) {
        Tags tags = this.local;
        if (this.enabledLabels.contains((Object)Label.REMOTE)) {
            tags = tags.and(Label.REMOTE.toString(), Labels.address(webSocket.remoteAddress()));
        }
        LongAdder wsConnections = this.longGaugeBuilder(this.names.getHttpActiveWsConnections(), LongAdder::doubleValue).description("Number of websockets currently opened").tags((Iterable<Tag>)tags).register(this.registry);
        wsConnections.increment();
        return wsConnections;
    }

    public void disconnected(LongAdder wsConnections) {
        wsConnections.decrement();
    }

    class RequestMetric {
        final Tags tags;
        final LongAdder requests;
        final Timer.Sample sample;
        Tags responseTags;
        boolean responseEnded;
        boolean requestEnded;
        boolean reset;

        RequestMetric(Tags tags) {
            this.tags = tags;
            this.responseTags = tags;
            this.requests = VertxHttpClientMetrics.this.longGaugeBuilder(VertxHttpClientMetrics.this.names.getHttpActiveRequests(), LongAdder::doubleValue).description("Number of requests waiting for a response").tags((Iterable<Tag>)tags).register(VertxHttpClientMetrics.this.registry);
            this.sample = Timer.start();
        }

        void requestReset() {
            this.reset = true;
        }

        boolean requestEnded() {
            this.requestEnded = true;
            return !this.reset && this.responseEnded;
        }

        void responseBegin(HttpResponse response) {
            if (VertxHttpClientMetrics.this.enabledLabels.contains((Object)Label.HTTP_CODE)) {
                this.responseTags = this.responseTags.and(Label.HTTP_CODE.toString(), String.valueOf(response.statusCode()));
            }
        }

        boolean responseEnded() {
            this.responseEnded = true;
            return !this.reset && this.requestEnded;
        }
    }

    class EndpointMetrics
    implements ClientMetrics<RequestMetric, HttpRequest, HttpResponse> {
        final Tags endPointTags;

        EndpointMetrics(Tags endPointTags) {
            this.endPointTags = endPointTags;
        }

        public RequestMetric requestBegin(String uri, HttpRequest request) {
            Tags tags = this.endPointTags;
            if (VertxHttpClientMetrics.this.enabledLabels.contains((Object)Label.HTTP_PATH)) {
                tags = tags.and(Label.HTTP_PATH.toString(), HttpUtils.parsePath(request.uri()));
            }
            if (VertxHttpClientMetrics.this.enabledLabels.contains((Object)Label.HTTP_METHOD)) {
                tags = tags.and(Label.HTTP_METHOD.toString(), request.method().toString());
            }
            if (VertxHttpClientMetrics.this.customTagsProvider != null) {
                tags = tags.and(VertxHttpClientMetrics.this.customTagsProvider.apply(request));
            }
            RequestMetric requestMetric = new RequestMetric(tags);
            requestMetric.requests.increment();
            ((Counter)VertxHttpClientMetrics.this.requestCount.withTags((Iterable)tags)).increment();
            return requestMetric;
        }

        public void requestEnd(RequestMetric requestMetric, long bytesWritten) {
            ((DistributionSummary)VertxHttpClientMetrics.this.requestBytes.withTags((Iterable)requestMetric.tags)).record((double)bytesWritten);
            if (requestMetric.requestEnded()) {
                requestMetric.requests.decrement();
            }
        }

        public void requestReset(RequestMetric requestMetric) {
            requestMetric.requests.decrement();
            requestMetric.requestReset();
        }

        public void responseBegin(RequestMetric requestMetric, HttpResponse response) {
            requestMetric.responseBegin(response);
        }

        public void responseEnd(RequestMetric requestMetric, long bytesRead) {
            if (requestMetric.responseEnded()) {
                requestMetric.requests.decrement();
            }
            ((Counter)VertxHttpClientMetrics.this.responseCount.withTags((Iterable)requestMetric.responseTags)).increment();
            requestMetric.sample.stop((Timer)VertxHttpClientMetrics.this.responseTime.withTags((Iterable)requestMetric.responseTags));
            ((DistributionSummary)VertxHttpClientMetrics.this.responseBytes.withTags((Iterable)requestMetric.responseTags)).record((double)bytesRead);
        }
    }
}

