/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.tags.Labels;
import java.util.concurrent.atomic.LongAdder;

class VertxNetClientMetrics
extends AbstractMetrics
implements TCPMetrics<NetClientSocketMetric> {
    final Tags local;
    private final Meter.MeterProvider<Counter> netErrorCount;

    VertxNetClientMetrics(AbstractMetrics parent, String localAddress) {
        this(parent, MetricsDomain.NET_CLIENT, localAddress);
    }

    VertxNetClientMetrics(AbstractMetrics parent, MetricsDomain domain, String localAddress) {
        super(parent, domain);
        this.local = this.enabledLabels.contains((Object)Label.LOCAL) ? Tags.of((String)Label.LOCAL.toString(), (String)(localAddress == null ? "?" : localAddress)) : Tags.empty();
        this.netErrorCount = Counter.builder((String)this.names.getNetErrorCount()).description("Number of errors").withRegistry(this.registry);
    }

    public NetClientSocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        Tags tags = this.local;
        if (this.enabledLabels.contains((Object)Label.REMOTE)) {
            tags = tags.and(Label.REMOTE.toString(), Labels.address(remoteAddress, remoteName));
        }
        NetClientSocketMetric socketMetric = new NetClientSocketMetric(tags);
        socketMetric.connections.increment();
        return socketMetric;
    }

    public void disconnected(NetClientSocketMetric socketMetric, SocketAddress remoteAddress) {
        socketMetric.connections.decrement();
    }

    public void bytesRead(NetClientSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesReceived.increment((double)numberOfBytes);
    }

    public void bytesWritten(NetClientSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesSent.increment((double)numberOfBytes);
    }

    public void exceptionOccurred(NetClientSocketMetric socketMetric, SocketAddress remoteAddress, Throwable t) {
        Tags tags = socketMetric.tags;
        if (this.enabledLabels.contains((Object)Label.CLASS_NAME)) {
            tags = tags.and(Label.CLASS_NAME.toString(), t.getClass().getSimpleName());
        }
        ((Counter)this.netErrorCount.withTags((Iterable)tags)).increment();
    }

    class NetClientSocketMetric {
        final Tags tags;
        final LongAdder connections;
        final Counter bytesReceived;
        final Counter bytesSent;

        NetClientSocketMetric(Tags tags) {
            this.tags = tags;
            this.connections = VertxNetClientMetrics.this.longGaugeBuilder(VertxNetClientMetrics.this.names.getNetActiveConnections(), LongAdder::doubleValue).description("Number of connections to the remote host currently opened").tags((Iterable<Tag>)tags).register(VertxNetClientMetrics.this.registry);
            this.bytesReceived = Counter.builder((String)VertxNetClientMetrics.this.names.getNetBytesRead()).description("Number of bytes received from the remote host").tags((Iterable)tags).register(VertxNetClientMetrics.this.registry);
            this.bytesSent = Counter.builder((String)VertxNetClientMetrics.this.names.getNetBytesWritten()).description("Number of bytes sent to the remote host").tags((Iterable)tags).register(VertxNetClientMetrics.this.registry);
        }
    }
}

