/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.meters;

import io.micrometer.core.instrument.Meter;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

class LongAdderSupplier
implements Supplier<Number> {
    private final ConcurrentMap<Meter.Id, LongAdder> longGauges;
    private final ToDoubleFunction<LongAdder> func;
    private volatile Meter.Id id;

    LongAdderSupplier(ConcurrentMap<Meter.Id, LongAdder> longGauges, ToDoubleFunction<LongAdder> func) {
        this.longGauges = longGauges;
        this.func = func;
    }

    void setId(Meter.Id id) {
        this.id = id;
    }

    @Override
    public Number get() {
        LongAdder longAdder;
        Meter.Id key = this.id;
        if (key != null && (longAdder = (LongAdder)this.longGauges.get(key)) != null) {
            return this.func.applyAsDouble(longAdder);
        }
        return null;
    }
}

