/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptionsConverter;
import java.util.Map;
import java.util.Objects;

@DataObject
@JsonGen(publicConverter=false)
public class CollationOptions {
    public static final String DEFAULT_LOCALE = "simple";
    private String locale;
    private Boolean caseLevel;
    private CollationCaseFirst caseFirst;
    private CollationStrength strength;
    private Boolean numericOrdering;
    private CollationAlternate alternate;
    private CollationMaxVariable maxVariable;
    private Boolean backwards;
    private Boolean normalization;

    public CollationOptions() {
        this.locale = DEFAULT_LOCALE;
    }

    public CollationOptions(CollationOptions options) {
        this.locale = options.locale;
        this.caseLevel = options.caseLevel;
        this.caseFirst = options.caseFirst;
        this.strength = options.strength;
        this.numericOrdering = options.numericOrdering;
        this.alternate = options.alternate;
        this.maxVariable = options.maxVariable;
        this.backwards = options.backwards;
        this.normalization = options.normalization;
    }

    public Collation toMongoDriverObject() {
        if (this.locale == null || DEFAULT_LOCALE.equals(this.locale)) {
            return Collation.builder().locale(DEFAULT_LOCALE).build();
        }
        return Collation.builder().backwards(this.isBackwards()).caseLevel(this.isCaseLevel()).collationCaseFirst(this.getCaseFirst()).collationMaxVariable(this.getMaxVariable()).collationStrength(this.getStrength()).locale(this.getLocale()).numericOrdering(this.isNumericOrdering()).collationAlternate(this.getAlternate()).normalization(this.isNormalization()).build();
    }

    public CollationOptions(JsonObject json) {
        this();
        CollationOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        if (json.getValue("alternate") instanceof String) {
            this.alternate = CollationAlternate.fromString((String)json.getString("alternate"));
        }
        if (json.getValue("caseFirst") instanceof String) {
            this.caseFirst = CollationCaseFirst.fromString((String)json.getString("caseFirst"));
        }
        if (json.getValue("maxVariable") instanceof String) {
            this.maxVariable = CollationMaxVariable.fromString((String)json.getString("maxVariable"));
        }
        if (json.getValue("strength") instanceof Integer) {
            this.strength = CollationStrength.fromInt((int)json.getInteger("strength"));
        }
    }

    public Boolean isNormalization() {
        return this.normalization;
    }

    public CollationOptions setNormalization(Boolean normalization) {
        this.normalization = normalization;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CollationOptionsConverter.toJson(this, json);
        if (this.alternate != null) {
            json.put("alternate", (Object)this.alternate.getValue());
        }
        if (this.caseFirst != null) {
            json.put("caseFirst", (Object)this.caseFirst.getValue());
        }
        if (this.maxVariable != null) {
            json.put("maxVariable", (Object)this.maxVariable.getValue());
        }
        if (this.strength != null) {
            json.put("strength", (Object)this.strength.getIntRepresentation());
        }
        return json;
    }

    public String getLocale() {
        return this.locale;
    }

    public CollationOptions setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public Boolean isCaseLevel() {
        return this.caseLevel;
    }

    public CollationOptions setCaseLevel(Boolean caseLevel) {
        this.caseLevel = caseLevel;
        return this;
    }

    @GenIgnore
    public CollationCaseFirst getCaseFirst() {
        return this.caseFirst;
    }

    @GenIgnore
    public CollationOptions setCaseFirst(CollationCaseFirst caseFirst) {
        this.caseFirst = caseFirst;
        return this;
    }

    public CollationStrength getStrength() {
        return this.strength;
    }

    public CollationOptions setStrength(CollationStrength strength) {
        this.strength = strength;
        return this;
    }

    public Boolean isNumericOrdering() {
        return this.numericOrdering;
    }

    public CollationOptions setNumericOrdering(Boolean numericOrdering) {
        this.numericOrdering = numericOrdering;
        return this;
    }

    @GenIgnore
    public CollationAlternate getAlternate() {
        return this.alternate;
    }

    @GenIgnore
    public CollationOptions setAlternate(CollationAlternate alternate) {
        this.alternate = alternate;
        return this;
    }

    @GenIgnore
    public CollationMaxVariable getMaxVariable() {
        return this.maxVariable;
    }

    @GenIgnore
    public CollationOptions setMaxVariable(CollationMaxVariable maxVariable) {
        this.maxVariable = maxVariable;
        return this;
    }

    public Boolean isBackwards() {
        return this.backwards;
    }

    public CollationOptions setBackwards(Boolean backwards) {
        this.backwards = backwards;
        return this;
    }

    public String toString() {
        return "CollationOptions{locale='" + this.locale + "', caseLevel=" + this.caseLevel + ", caseFirst=" + String.valueOf(this.caseFirst) + ", strength=" + String.valueOf(this.strength) + ", numericOrdering=" + this.numericOrdering + ", alternate='" + String.valueOf(this.alternate) + "', maxVariable=" + String.valueOf(this.maxVariable) + ", backwards=" + this.backwards + ", normalization=" + this.normalization + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollationOptions that = (CollationOptions)o;
        return this.caseLevel == that.caseLevel && this.strength == that.strength && this.numericOrdering == that.numericOrdering && this.backwards == that.backwards && this.normalization == that.normalization && Objects.equals(this.locale, that.locale) && this.caseFirst == that.caseFirst && Objects.equals(this.alternate, that.alternate) && this.maxVariable == that.maxVariable;
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.caseLevel, this.caseFirst, this.strength, this.numericOrdering, this.alternate, this.maxVariable, this.backwards, this.normalization);
    }
}

