/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.IndexOptionDefaults;
import com.mongodb.lang.Nullable;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CreateCollectionOptionsConverter;
import io.vertx.ext.mongo.TimeSeriesOptions;
import io.vertx.ext.mongo.ValidationOptions;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

@DataObject
@JsonGen(publicConverter=false)
public class CreateCollectionOptions {
    private Long maxDocuments;
    private Boolean capped;
    private TimeSeriesOptions timeSeriesOptions;
    private Long sizeInBytes;
    private JsonObject storageEngineOptions;
    private JsonObject indexOptionDefaults;
    private ValidationOptions validationOptions;
    private CollationOptions collation;
    private Long expireAfterSeconds;

    public CreateCollectionOptions() {
        this.maxDocuments = null;
        this.capped = null;
        this.timeSeriesOptions = null;
        this.sizeInBytes = null;
        this.storageEngineOptions = null;
        this.indexOptionDefaults = null;
        this.validationOptions = null;
        this.collation = null;
        this.expireAfterSeconds = null;
    }

    public CreateCollectionOptions(CreateCollectionOptions other) {
        this.maxDocuments = other.getMaxDocuments();
        this.capped = other.getCapped();
        this.timeSeriesOptions = other.getTimeSeriesOptions();
        this.sizeInBytes = other.getSizeInBytes();
        this.storageEngineOptions = other.getStorageEngineOptions();
        this.indexOptionDefaults = other.getIndexOptionDefaults();
        this.validationOptions = other.getValidationOptions();
        this.collation = other.getCollation();
        this.expireAfterSeconds = other.getExpireAfterSeconds();
    }

    public CreateCollectionOptions(JsonObject json) {
        CreateCollectionOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CreateCollectionOptionsConverter.toJson(this, json);
        return json;
    }

    public Long getMaxDocuments() {
        return this.maxDocuments;
    }

    public CreateCollectionOptions setMaxDocuments(Long maxDocuments) {
        this.maxDocuments = maxDocuments;
        return this;
    }

    public com.mongodb.client.model.CreateCollectionOptions toMongoDriverObject() {
        com.mongodb.client.model.CreateCollectionOptions createCollectionOptions = new com.mongodb.client.model.CreateCollectionOptions();
        if (this.capped != null) {
            createCollectionOptions.capped(this.capped.booleanValue());
        }
        if (this.timeSeriesOptions != null) {
            createCollectionOptions.timeSeriesOptions(this.timeSeriesOptions.toMongoDriverObject());
        }
        if (this.maxDocuments != null) {
            createCollectionOptions.maxDocuments(this.maxDocuments.longValue());
        }
        if (this.sizeInBytes != null) {
            createCollectionOptions.sizeInBytes(this.sizeInBytes.longValue());
        }
        if (this.collation != null) {
            createCollectionOptions.collation(this.collation.toMongoDriverObject());
        }
        if (this.indexOptionDefaults != null) {
            createCollectionOptions.indexOptionDefaults(new IndexOptionDefaults().storageEngine((Bson)BsonDocument.parse((String)this.indexOptionDefaults.encode())));
        }
        if (this.validationOptions != null) {
            createCollectionOptions.validationOptions(this.validationOptions.toMongoDriverObject());
        }
        if (this.storageEngineOptions != null) {
            createCollectionOptions.storageEngineOptions((Bson)BsonDocument.parse((String)this.storageEngineOptions.encode()));
        }
        if (this.expireAfterSeconds != null) {
            createCollectionOptions.expireAfter(this.expireAfterSeconds.longValue(), TimeUnit.SECONDS);
        }
        return createCollectionOptions;
    }

    public CreateCollectionOptions setCapped(Boolean capped) {
        this.capped = capped;
        return this;
    }

    public Boolean getCapped() {
        return this.capped;
    }

    public TimeSeriesOptions getTimeSeriesOptions() {
        return this.timeSeriesOptions;
    }

    public CreateCollectionOptions setTimeSeriesOptions(TimeSeriesOptions timeSeriesOptions) {
        this.timeSeriesOptions = (TimeSeriesOptions)Assertions.notNull((String)"timeseries", (Object)timeSeriesOptions);
        return this;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public CreateCollectionOptions setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    @Nullable
    public JsonObject getStorageEngineOptions() {
        return this.storageEngineOptions;
    }

    public CreateCollectionOptions setStorageEngineOptions(@Nullable JsonObject storageEngineOptions) {
        this.storageEngineOptions = storageEngineOptions;
        return this;
    }

    public JsonObject getIndexOptionDefaults() {
        return this.indexOptionDefaults;
    }

    public CreateCollectionOptions setIndexOptionDefaults(JsonObject indexOptionDefaults) {
        this.indexOptionDefaults = (JsonObject)Assertions.notNull((String)"indexOptionDefaults", (Object)indexOptionDefaults);
        return this;
    }

    public ValidationOptions getValidationOptions() {
        return this.validationOptions;
    }

    public CreateCollectionOptions setValidationOptions(ValidationOptions validationOptions) {
        this.validationOptions = (ValidationOptions)Assertions.notNull((String)"validationOptions", (Object)validationOptions);
        return this;
    }

    @Nullable
    public CollationOptions getCollation() {
        return this.collation;
    }

    public CreateCollectionOptions setCollation(@Nullable CollationOptions collation) {
        this.collation = collation;
        return this;
    }

    public Long getExpireAfterSeconds() {
        return this.expireAfterSeconds;
    }

    public CreateCollectionOptions setExpireAfterSeconds(Long expireAfterSeconds) {
        this.expireAfterSeconds = expireAfterSeconds;
        return this;
    }

    public String toString() {
        return "CreateCollectionOptions{maxDocuments=" + this.maxDocuments + ", capped=" + this.capped + ", timeSeriesOptions=" + String.valueOf(this.timeSeriesOptions) + ", sizeInBytes=" + this.sizeInBytes + ", storageEngineOptions=" + String.valueOf(this.storageEngineOptions) + ", indexOptionDefaults=" + String.valueOf(this.indexOptionDefaults) + ", validationOptions=" + String.valueOf(this.validationOptions) + ", collation=" + String.valueOf(this.collation) + ", expireAfter=" + this.expireAfterSeconds + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCollectionOptions that = (CreateCollectionOptions)o;
        return Objects.equals(this.maxDocuments, that.maxDocuments) && Objects.equals(this.capped, that.capped) && Objects.equals(this.timeSeriesOptions, that.timeSeriesOptions) && Objects.equals(this.sizeInBytes, that.sizeInBytes) && Objects.equals(this.storageEngineOptions, that.storageEngineOptions) && Objects.equals(this.indexOptionDefaults, that.indexOptionDefaults) && Objects.equals(this.validationOptions, that.validationOptions) && Objects.equals(this.collation, that.collation) && Objects.equals(this.expireAfterSeconds, that.expireAfterSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.maxDocuments, this.capped, this.timeSeriesOptions, this.sizeInBytes, this.storageEngineOptions, this.indexOptionDefaults, this.validationOptions, this.collation, this.expireAfterSeconds);
    }
}

