/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.TimeSeriesGranularity;
import io.vertx.ext.mongo.TimeSeriesOptionsConverter;
import java.util.Map;
import java.util.Objects;

@DataObject
@JsonGen(publicConverter=false)
public class TimeSeriesOptions {
    public static final String DEFAULT_TIME_FIELD = "timestamp";
    private String timeField;
    private String metaField;
    private TimeSeriesGranularity granularity;

    public TimeSeriesOptions() {
        this.init();
    }

    private void init() {
        this.timeField = DEFAULT_TIME_FIELD;
    }

    public TimeSeriesOptions(TimeSeriesOptions options) {
        this.timeField = options.timeField;
        this.metaField = options.metaField;
        this.granularity = options.granularity;
    }

    public TimeSeriesOptions(JsonObject json) {
        this.init();
        TimeSeriesOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        TimeSeriesOptionsConverter.toJson(this, json);
        return json;
    }

    public com.mongodb.client.model.TimeSeriesOptions toMongoDriverObject() {
        com.mongodb.client.model.TimeSeriesOptions timeSeriesOptions = new com.mongodb.client.model.TimeSeriesOptions(this.timeField);
        if (this.metaField != null) {
            timeSeriesOptions.metaField(this.metaField);
        }
        if (this.granularity != null) {
            switch (this.granularity) {
                case SECONDS: {
                    timeSeriesOptions.granularity(com.mongodb.client.model.TimeSeriesGranularity.SECONDS);
                    break;
                }
                case MINUTES: {
                    timeSeriesOptions.granularity(com.mongodb.client.model.TimeSeriesGranularity.MINUTES);
                    break;
                }
                case HOURS: {
                    timeSeriesOptions.granularity(com.mongodb.client.model.TimeSeriesGranularity.HOURS);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.granularity.toString());
                }
            }
        }
        return timeSeriesOptions;
    }

    public String getTimeField() {
        return this.timeField;
    }

    public TimeSeriesOptions setTimeField(String timeField) {
        this.timeField = timeField;
        return this;
    }

    public String getMetaField() {
        return this.metaField;
    }

    public TimeSeriesOptions setMetaField(String metaField) {
        this.metaField = metaField;
        return this;
    }

    public TimeSeriesGranularity getGranularity() {
        return this.granularity;
    }

    public TimeSeriesOptions setGranularity(TimeSeriesGranularity granularity) {
        this.granularity = granularity;
        return this;
    }

    public String toString() {
        return "TimeseriesOptions{timeField='" + this.timeField + "', metaField=" + this.metaField + ", granularity=" + String.valueOf((Object)this.granularity) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeriesOptions that = (TimeSeriesOptions)o;
        return Objects.equals(this.timeField, that.timeField) && Objects.equals(this.metaField, that.metaField) && Objects.equals((Object)this.granularity, (Object)that.granularity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeField, this.metaField, this.granularity});
    }
}

