/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class GridFSReadStreamPublisher
implements Publisher<ByteBuffer> {
    private final ReadStream<Buffer> stream;
    private final AtomicReference<Subscription> current;

    public GridFSReadStreamPublisher(ReadStream<Buffer> stream) {
        this.stream = stream;
        this.current = new AtomicReference();
    }

    private void release() {
        Subscription sub = this.current.get();
        if (sub != null && this.current.compareAndSet(sub, null)) {
            try {
                this.stream.exceptionHandler(null);
                this.stream.endHandler(null);
                this.stream.handler(null);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    this.stream.resume();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        Subscription sub = new Subscription(){

            public void request(long l) {
                if (GridFSReadStreamPublisher.this.current.get() == this) {
                    GridFSReadStreamPublisher.this.stream.fetch(l);
                }
            }

            public void cancel() {
                GridFSReadStreamPublisher.this.release();
            }
        };
        if (!this.current.compareAndSet(null, sub)) {
            subscriber.onError((Throwable)new IllegalStateException("This processor allows only a single Subscriber"));
            return;
        }
        this.stream.pause();
        this.stream.endHandler(v -> {
            this.release();
            subscriber.onComplete();
        });
        this.stream.exceptionHandler(err -> {
            this.release();
            subscriber.onError(err);
        });
        this.stream.handler(buffer -> {
            byte[] bytes = buffer.getBytes();
            ByteBuffer wrapper = ByteBuffer.wrap(bytes);
            subscriber.onNext((Object)wrapper);
        });
        subscriber.onSubscribe(sub);
    }
}

